/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RewriteNotInSubqueryAsInnerJoin
extends RQETransformation {
    private static final String CTE_NAME = "CTE_$0";

    public RewriteNotInSubqueryAsInnerJoin() {
        this.mName = "Rewrite a NOT IN subquery as an inner join.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode withClause;
        IXQEQueryNode parent;
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode predicate = node.getParent();
        SQLFilter filter = (SQLFilter)predicate.getGrandParent();
        SQLSubQuery subQuery = (SQLSubQuery)node.detach();
        SQLQueryBlock qBlock = (SQLQueryBlock)subQuery.getChild(0).detach();
        IXQEQueryNode child = qBlock.getChild(0);
        while (!child.isOfCategory(301015)) {
            child = child.getChild(0);
        }
        SQLValueList vList = ((SQLProject)child).getOutputList();
        IXQEQueryNode baseNode = child.getChild(0);
        while (baseNode.getType() == 301009) {
            SQLExpression root = ((SQLFilter)baseNode).getPredicate();
            if (root.getType() == 301027 && ((SQLLogical)root).getSubType() == SQLLogical.SubType.NOT) {
                root.extract();
            } else {
                SQLLogical lNode = (SQLLogical)factory.createNode(301027);
                lNode.setSubType(SQLLogical.SubType.NOT);
                root.insertParent(lNode);
            }
            baseNode = baseNode.getChild(0);
        }
        baseNode = filter;
        while (baseNode.getType() == 301009) {
            baseNode = baseNode.getChild(0);
        }
        SQLQueryBlock parentQBlock = (SQLQueryBlock)filter.getAncestorOfType(301004);
        while ((parent = parentQBlock.getParent()).getType() != 301019 && parent.getType() != 401005) {
            parentQBlock = (SQLQueryBlock)parentQBlock.getAncestorOfType(301004);
        }
        if (parentQBlock.getChild(0).getType() == 301022) {
            withClause = parentQBlock.getChild(0);
        } else {
            withClause = factory.createNode(301022);
            parentQBlock.insertParent(withClause);
            SQLQueryBlock newQBlock = (SQLQueryBlock)factory.createNode(301004);
            newQBlock.setForeign(true);
            newQBlock.setDataSource(qBlock.getDataSource());
            newQBlock.setQueryItemList(parentQBlock.getQueryItemList());
            withClause.insertParent(newQBlock);
        }
        SQLRangeVar rangeVar = (SQLRangeVar)factory.createNode(301007);
        rangeVar.setName(CTE_NAME);
        rangeVar.addChild(qBlock.getChild(0));
        withClause.addChild(rangeVar, 0);
        SQLRelation rNode = (SQLRelation)factory.createNode(301016);
        rNode.setName(CTE_NAME);
        rNode.setWithClauseQueryRef(true);
        rNode.setQueryItemList(qBlock.getQueryItemList());
        SQLJoin jNode = null;
        int sourceNo = 1;
        if (baseNode.getType() == 301004 || baseNode.getType() == 301016 || baseNode.getType() == 301092) {
            IXQEQueryNode pNode = factory.createNode(301014);
            baseNode.insertParent(pNode);
            baseNode = pNode;
        } else if (baseNode.getType() == 301011) {
            sourceNo = ((SQLJoin)baseNode).getNumberOfLeafNodes();
            jNode = (SQLJoin)factory.createNode(301011);
            jNode.setJoinType(SQLJoin.SubType.INNER);
            baseNode.insertParent(jNode);
            baseNode = jNode;
        } else {
            sourceNo = baseNode.getNumberChildren();
        }
        baseNode.addChild(rNode);
        Map<String, Object> hints = qBlock.getOrAddHints();
        hints.put("enforce_not_null", true);
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            SQLAlias alias = (SQLAlias)factory.createNode(301028);
            alias.setName("C_$0");
            aliasList.add(alias);
            vList.setAliasList(aliasList);
        }
        SQLFid fid = (SQLFid)factory.createNode(301032);
        fid.setSourceNo(sourceNo);
        fid.setColumnNo(0);
        fid.setTableName(CTE_NAME);
        fid.setName(vList.getAlias(0));
        fid.setDataType(((SQLQueryNode)vList.getChild(0)).getDataType());
        predicate.getParent().extract();
        predicate.addChild(fid);
        SQLComparison compareExpr = (SQLComparison)factory.createNode(301026);
        compareExpr.setSubType(SQLComparison.SubType.EQUAL);
        predicate.exchange(compareExpr, true);
        if (jNode != null) {
            predicate.move(jNode);
            filter.extract();
        } else {
            FactorAnalyzer.analyze(filter);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        Object hint;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode predicate = node.getParent();
        SQLSubQuery subQuery = (SQLSubQuery)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)predicate.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        Map<String, Object> hints = subQuery.getHints();
        boolean rewriteAsInnerJoin = false;
        if (hints != null && (hint = hints.get("rewrite_as_inner_join")) != null) {
            rewriteAsInnerJoin = (Boolean)hint;
        }
        boolean bl = status = subQuery.rewriteAsJoin() && !subQuery.isCorrelatedSubQuery() && qBlock.isForeign() && predicate.getType() == 301076 && predicate.getParent().getType() == 301027 && ((SQLLogical)predicate.getParent()).getSubType() == SQLLogical.SubType.NOT && dataSource != null && SQLWith.isFeatureSupported(dataSource.getCapabilities());
        if (status && !rewriteAsInnerJoin) {
            SQLValueList vList;
            IXQEQueryNode exprNode;
            status = false;
            IXQEQueryNode root = predicate.getChild(1);
            while (!root.isOfCategory(301015)) {
                root = root.getChild(0);
            }
            if (root.getChild(0).getType() == 301009 && (exprNode = (vList = ((SQLProject)root).getOutputList()).getChild(0)).getType() == 301032) {
                status = ((SQLFid)exprNode).isUnique();
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Subquery can be converted to an inner join.", trace);
        } else {
            this.traceQueryCondition(status, "Subquery cannot be converted to an inner join.", trace);
        }
        return status;
    }
}

