/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RewriteSubqueryAsJoin
extends RQETransformation {
    private static final String JOIN_METHOD = "joinMethod";
    private static final String SEMI_JOIN = "'semi'";

    public RewriteSubqueryAsJoin() {
        this.mName = "Convert a subquery to a join.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLValueList vList;
        List<SQLAlias> aliasList;
        SQLProduct pNode;
        XQENodeFactory factory = environment.getNodeFactory();
        SQLSubQuery parentSubQuery = null;
        int contextNo = 0;
        if (((SQLSubQuery)node).hasParentSubQuery()) {
            parentSubQuery = (SQLSubQuery)node.getAncestorOfType(301059);
            contextNo = parentSubQuery.getContextNo();
        }
        SQLQueryNode predicate = (SQLQueryNode)node.getParent();
        SQLFilter filterNode = (SQLFilter)predicate.getAncestorOfType(301009);
        IXQEQueryNode baseNode1 = predicate.getParent();
        if (predicate.getType() == 301055) {
            baseNode1 = baseNode1.getParent();
        }
        while (baseNode1.getType() == 301009) {
            baseNode1 = baseNode1.getChild(0);
        }
        if (baseNode1.getType() != 301014) {
            pNode = (SQLProduct)factory.createNode(301014);
            baseNode1.insertParent(pNode);
            if (baseNode1.getType() == 301011) {
                IXQEQueryNode fNode = filterNode;
                while (fNode.getType() == 301009) {
                    IXQEQueryNode[] subQueries;
                    IXQEQueryNode[] fids;
                    SQLExpression fPredicate = fNode.getPredicate();
                    for (IXQEQueryNode fid : fids = fPredicate.getDescendantsOfType(301032, false, 301059)) {
                        ((SQLFid)fid).setSourceNo(0);
                    }
                    for (IXQEQueryNode fSubQuery : subQueries = fPredicate.getDescendantsOfType(301059, false)) {
                        IXQEQueryNode[] xids;
                        for (IXQEQueryNode xid : xids = fSubQuery.getDescendantsOfType(301082, false)) {
                            if (((SQLXid)xid).getContextNo() != contextNo) continue;
                            ((SQLXid)xid).setSourceNo(0);
                        }
                    }
                    fNode = fNode.getParent();
                }
            }
        } else {
            pNode = (SQLProduct)baseNode1;
        }
        SQLSubQuery subQuery = (SQLSubQuery)node.detach();
        SQLQueryBlock qBlock = (SQLQueryBlock)subQuery.getChild(0).detach();
        IXQEQueryNode root = qBlock.getChild(0);
        while (!root.isOfCategory(301015)) {
            root = root.getChild(0);
        }
        int sourceNo = ((SQLQueryNode)baseNode1).getNumberOfLeafNodes();
        int vSourceNo = pNode.getNumberChildren();
        qBlock.setName(String.format("T_$%d", sourceNo));
        pNode.addChild(qBlock);
        if (predicate.getType() == 301026 && root.getType() != 301010) {
            Map<String, Object> hints = qBlock.getOrAddHints();
            hints.put("maxcard", 1);
        }
        if ((aliasList = (vList = ((SQLProject)root).getOutputList()).getAliasList()) == null) {
            aliasList = new ArrayList<SQLAlias>();
            SQLAlias alias = (SQLAlias)factory.createNode(301028);
            alias.setName("C_$0");
            aliasList.add(alias);
            vList.setAliasList(aliasList);
        }
        SQLFid fid = (SQLFid)factory.createNode(301032);
        fid.setSourceNo(vSourceNo);
        fid.setColumnNo(0);
        fid.setTableName(qBlock.getName());
        fid.setName(vList.getAlias(0));
        fid.setDataType(((SQLQueryNode)vList.getChild(0)).getDataType());
        IDataSource dataSource = qBlock.getDataSource();
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        if (subQuery.isCorrelatedSubQuery()) {
            IXQEQueryNode child = root.getChild(0);
            while (child.getType() == 301009) {
                SQLFilter factor = (SQLFilter)child;
                child = child.getChild(0);
                List<SQLXid> xidList = CollectionCast.downcast(factor.getPredicate().getDescendantsOfTypeOrdered(301082, 301004), IXQEQueryNode.class, SQLXid.class);
                if (xidList.size() == 0) continue;
                factorList.add(factor);
            }
        }
        boolean addSemiJoinHint = dataSource.getCapabilities().isSupported("performance.semiJoin") && contextNo == 0;
        boolean genDistinct = false;
        if (predicate.getType() == 301055) {
            predicate = (SQLQueryNode)predicate.getParent();
            predicate.getChild(1).extract();
            if (addSemiJoinHint) {
                Map<String, Object> hints = predicate.getOrAddHints();
                hints.put(JOIN_METHOD, SEMI_JOIN);
            } else {
                genDistinct = true;
            }
        }
        predicate.addChild(fid);
        if (predicate.getType() == 301076) {
            SQLComparison compareExpr = (SQLComparison)factory.createNode(301026);
            compareExpr.setSubType(SQLComparison.SubType.EQUAL);
            predicate.exchange(compareExpr, true);
            if (addSemiJoinHint) {
                Map<String, Object> hints = compareExpr.getOrAddHints();
                hints.put(JOIN_METHOD, SEMI_JOIN);
            } else {
                genDistinct = true;
            }
        }
        FactorAnalyzer.analyze(filterNode);
        if (genDistinct && root.getParent().getType() != 301008) {
            root.insertParent(factory.createNode(301008));
        }
        if (subQuery.isCorrelatedSubQuery()) {
            for (SQLFilter factor : factorList) {
                List<SQLXid> xidList = CollectionCast.downcast(factor.getPredicate().getDescendantsOfTypeOrdered(301082, 301004), IXQEQueryNode.class, SQLXid.class);
                predicate = (SQLQueryNode)factor.getPredicate().detach();
                pNode.insertParent(factor.extract());
                factor.addChild(predicate);
                if (addSemiJoinHint && !subQuery.isScalarSubQuery()) {
                    Map<String, Object> hints = predicate.getOrAddHints();
                    hints.put(JOIN_METHOD, SEMI_JOIN);
                    if (predicate.getChild(0).getType() == 301032) {
                        predicate.addChild(predicate.getChild(0).detach());
                    }
                }
                List<SQLFid> fidList = CollectionCast.downcast(predicate.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
                for (SQLFid fid2 : fidList) {
                    SQLAlias alias;
                    String name;
                    int columnNo = vList.indexOf(fid2);
                    if (columnNo < 0) {
                        columnNo = vList.getNumberChildren();
                        fid = (SQLFid)factory.createNode(301032);
                        fid2.copyContentTo(factory, fid);
                        vList.addChild(fid);
                        name = String.format("C_$%d", columnNo);
                        alias = (SQLAlias)factory.createNode(301028);
                        alias.setName(name);
                        aliasList.add(alias);
                    } else {
                        alias = vList.getAliasList().get(columnNo);
                        name = alias.getName();
                    }
                    fid = (SQLFid)factory.createNode(301032);
                    fid.setSourceNo(vSourceNo);
                    fid.setColumnNo(columnNo);
                    fid.setTableName(qBlock.getName());
                    fid.setName(name);
                    fid.setDataType(fid2.getDataType());
                    fid2.exchange(fid);
                    if (root.getType() != 301010) continue;
                    SQLGroupByList groupByList = ((SQLGroupBy)root).getGroupByList();
                    fid = (SQLFid)factory.createNode(301032);
                    fid2.copyContentTo(factory, fid);
                    groupByList.addChild(fid);
                }
                for (SQLXid xid : xidList) {
                    if (xid.getContextNo() != contextNo) {
                        if (parentSubQuery == null) continue;
                        parentSubQuery.setCorrelatedSubQuery(true);
                        continue;
                    }
                    fid = (SQLFid)factory.createNode(301032);
                    xid.copyContentTo(factory, fid);
                    xid.exchange(fid);
                }
                FactorAnalyzer.analyze(factor);
            }
        }
        qBlock.setNumberColumns(vList.getNumberChildren());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode root;
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLSubQuery subQuery = (SQLSubQuery)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode predicate = subQuery.getParent();
        boolean bl = status = qBlock != null && qBlock.isForeign() && subQuery.rewriteAsJoin();
        if (status) {
            status = predicate.getType() == 301076 || predicate.getType() == 301026 ? predicate.getParent().getType() == 301009 : (predicate.getType() == 301055 ? ((SQLQuantifier)predicate).getSubType() != SQLQuantifier.SubType.ALL && ((SQLComparison)predicate.getParent()).getSubType() == SQLComparison.SubType.EQUAL && predicate.getGrandParent().getType() == 301009 : false);
        }
        if (status && subQuery.isCorrelatedSubQuery()) {
            root = subQuery.getChild(0).getChild(0);
            while (!root.isOfCategory(301015)) {
                root = root.getChild(0);
            }
            IXQEQueryNode child = root.getChild(0);
            int nEquiJoins = 0;
            while (child.getType() == 301009) {
                SQLFilter factor = (SQLFilter)child;
                if (factor.isCorrelated() && factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                    ++nEquiJoins;
                }
                child = child.getChild(0);
            }
            boolean bl2 = status = nEquiJoins > 0;
        }
        if (status) {
            root = subQuery.getChild(0).getChild(0);
            while (!root.isOfCategory(301015)) {
                root = root.getChild(0);
            }
            SQLValueList vList = ((SQLProject)root).getOutputList();
            IXQEQueryNode exprNode = vList.getChild(0);
            if (exprNode.getType() == 301034 && ((SQLAggregate)exprNode).getSubType() == SQLAggregate.SubType.COUNT_STAR) {
                status = false;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Subquery can be converted to a join.", trace);
        } else {
            this.traceQueryCondition(status, "Subquery cannot be converted to a join.", trace);
        }
        return status;
    }
}

