/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public final class SwapFilterAndProjection
extends RQETransformation {
    public SwapFilterAndProjection() {
        this(6);
    }

    public SwapFilterAndProjection(int passNumber) {
        this.mName = "SwapFilterAndProjection.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301009};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode temp = node.getChild(0);
        if (temp.getType() == 301004) {
            temp.extract();
            node.insertParent(temp);
        }
        SQLProject child = (SQLProject)node.getChild(0);
        SQLValueList vList = child.getOutputList();
        List<SQLFid> fidList = ((SQLFilter)node).getPredicate().getFieldIdentifiers();
        for (SQLFid fid : fidList) {
            fid.exchange(nodeFactory.deepCopyNode(vList.getChild(fid.getColumnNo())));
        }
        vList = (SQLValueList)child.detachSecondChild();
        node.insertParent(child.extract());
        child.addChild(vList);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        IDataSourceCapabilities capabilities;
        SQLQueryBlock block;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode child = node.getChild(0);
        IDataSource dataSource = null;
        if (child.getType() == 301004 && (dataSource = (block = (SQLQueryBlock)child).getDataSource()) != null && dataSource.isRelational() && node.getChild(1).isSupported(dataSource) && block.getReusableQuery() == null && SQLFilter.isFeatureSupported(capabilities = dataSource.getCapabilities())) {
            child = child.getChild(0);
        }
        boolean bl = status = child.getType() == 301015;
        if (status) {
            SQLValueList vList = ((SQLProject)child).getOutputList();
            IXQEQueryNode[] aggregates = vList.getDescendantsOfType(301034, true);
            boolean bl2 = status = aggregates.length == 0;
            if (status) {
                List<SQLFid> fidList = ((SQLFilter)node).getPredicate().getFieldIdentifiers();
                if (dataSource == null) {
                    dataSource = ((SQLFilter)node).getDataSource();
                }
                for (int i = 0; i < fidList.size() && status && dataSource != null; ++i) {
                    SQLFid fid = fidList.get(i);
                    SQLQueryNode sqlQueryNode = (SQLQueryNode)vList.getChild(fid.getColumnNo());
                    if (sqlQueryNode instanceof SQLFid) continue;
                    status = sqlQueryNode.isSupported(dataSource);
                }
            }
        }
        if (status) {
            status = SwapFilterAndProjection.canFilterBePushedToQueryBlock(node);
        }
        if (status) {
            this.traceQueryCondition(status, "Filter node is adjacent to a projection node.", trace);
        } else {
            this.traceQueryCondition(status, "Filter node is not adjacent to a projection node.", trace);
        }
        return status;
    }

    private static boolean canFilterBePushedToQueryBlock(IXQEQueryNode node) {
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301004 && ((SQLQueryBlock)child).isForeign()) {
            List<IXQEQueryNode> list = node.getChild(1).getDescendantsOfTypeOrdered(301016, false);
            for (IXQEQueryNode item : list) {
                if (!((SQLRelation)item).isWithClauseQueryRef()) continue;
                return false;
            }
        }
        return true;
    }
}

