/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rolap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class InitializeROLAPQuery
extends Transformation {
    public InitializeROLAPQuery(int[] passNumbers) {
        this.mName = "Initialize ROLAP Query.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101006};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        query.setPropertyValue("isROLAP", Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.getPropertyValue("isROLAP") != null) {
            this.traceNodeCondition(false, "InitializeROLAPQuery transformation has already been applied", trace);
            return false;
        }
        if (ROLAPUtilities.isQueryROLAP(environment)) {
            this.traceNodeCondition(true, "The V5 query is a ROLAP query", trace);
            return true;
        }
        this.traceNodeCondition(false, "The V5 query is not a ROLAP query", trace);
        return false;
    }
}

