/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.trace.XQETrace;

public class AddRSAPIEdge
extends Transformation {
    public AddRSAPIEdge() {
        this.mName = "Add RS API Edge to QRD edge node.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 0;
        this.mTypes = new int[1];
        this.mTypes[0] = 101049;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode dataset = node.getAncestorOfType(401005);
        if (dataset == null) {
            status = false;
            this.traceNodeCondition(status, "No RS API dataset has been assigned to the parent QRD yet.", trace);
        } else {
            RSAPIEdge edge = (RSAPIEdge)node.getPropertyValue("RSAPIEdge");
            if (edge == null) {
                status = true;
                this.traceNodeCondition(status, "No RS API edge has been assigned to the node yet.", trace);
            } else {
                status = false;
                this.traceNodeCondition(status, "An RS API edge has already been assigned to the node.", trace);
            }
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIEdge edge = new RSAPIEdge();
        edge.setName((String)node.getPropertyValue("name"));
        int edgeId = ((V5Edge)node).getEdgeID();
        edge.setOrdinal(edgeId);
        node.setPropertyValue("RSAPIEdge", edge);
        RSAPIDataset dataset = (RSAPIDataset)node.getAncestorOfType(401005);
        edge.setDataset(dataset);
        dataset.addEdge(edge);
    }
}

