/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;

public class AddRSAPIHeadersFooters
extends Transformation {
    public AddRSAPIHeadersFooters() {
        this.mName = "Add RS API data item references to a value set's rowset.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 0;
        this.mTypes = new int[2];
        this.mTypes[0] = 101052;
        this.mTypes[1] = 101053;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        RSAPIEdgeRowset parentRowset = (RSAPIEdgeRowset)parent.getPropertyValue("RSAPIEdgeRowset");
        if (parentRowset == null) {
            status = false;
            this.traceNodeCondition(status, "An RS API rowset is not available for the group body.", trace);
        } else {
            RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
            if (rowset == null) {
                status = true;
                this.traceNodeCondition(status, "The group header/footer rowset has not yet been created.", trace);
            } else {
                status = false;
                this.traceNodeCondition(status, "The group header/footer rowset has already been created.", trace);
            }
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIEdgeRowset rowset = new RSAPIEdgeRowset();
        rowset.setName((String)node.getPropertyValue("name"));
        node.setPropertyValue("RSAPIEdgeRowset", rowset);
        IXQEQueryNode edge = node.getAncestorOfType(101049);
        RSAPIEdge rsapiEdge = (RSAPIEdge)edge.getPropertyValue("RSAPIEdge");
        rowset.setEdge(rsapiEdge);
        rowset.setRowsetId(rsapiEdge.getNextRowsetId());
        V5QueryResultDefinition qrdRoot = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        IXQEQueryNode[] dataItemRefs = node.getChildrenOfTypeOrdered(101015);
        RSAPIUtilities.transferV5DataItemsToRSAPIRowset(RSAPIUtilities.findAssociatedQuery(node), dataItemRefs, rowset, qrdRoot.isList());
        IXQEQueryNode edgeGroup = node.getAncestorOfType(101050);
        IXQEQueryNode edgeGroupParent = edgeGroup.getParent();
        int edgeGroupPosition = edgeGroupParent.getPositionOfChild(edgeGroup);
        if (edgeGroupPosition > 0) {
            IXQEQueryNode valueSet = null;
            for (int i = edgeGroupPosition - 1; i >= 0 && (valueSet = edgeGroupParent.getChild(i)).getType() != 101057; --i) {
            }
            RSAPIEdgeRowset parentRowset = (RSAPIEdgeRowset)valueSet.getPropertyValue("RSAPIEdgeRowset");
            rowset.setParentRowset(parentRowset);
        }
        IXQEQueryNode detail = node.getParent();
        RSAPIEdgeRowset detailRowset = (RSAPIEdgeRowset)detail.getPropertyValue("RSAPIEdgeRowset");
        if (node.getType() == 101052) {
            detailRowset.setFooterRowset(rowset);
        } else {
            detailRowset.setHeaderRowset(rowset);
        }
        rsapiEdge.addRowset(rowset);
    }
}

