/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.XTree;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class GenerateXTree
extends RQETransformation {
    public GenerateXTree() {
        this.mName = "Generate Run Tree.";
        this.mPassNumbers = new int[]{12};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{401005};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        environment.getRequestEnvironment().setModelPath(environment.getModelPath());
        XTree xTree = (XTree)nodeFactory.createXNode(501021);
        xTree.setModelPath(environment.getModelPath());
        node.getChild(0).insertParent(xTree);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int status = node.isValidPlannedQuery();
        if (status == -1) {
            this.traceQueryCondition(true, "The query is valid.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The query is not valid. Found issues in node " + status, trace);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String nodeName = nodeFactory.getNodeTypeName(status);
        if (nodeName == null) {
            IXQEQueryNode faultyNode = (IXQEQueryNode)nodeFactory.getNodeIndex().getNodeByID(status);
            nodeName = faultyNode.getNodeTypeName();
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_V5PlanFailed, nodeName);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getNumberChildren() > 0;
        if (status) {
            this.traceQueryCondition(status, "Run tree has been generated.", trace);
        } else {
            this.traceQueryCondition(status, "Run tree has not been generated.", trace);
        }
        return status;
    }
}

