/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class ReplaceV5QuerySet
extends Transformation {
    public ReplaceV5QuerySet() {
        this.mName = "Replace the V5QuerySet node.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (environment.getRoot().getType() == 1101013) {
            this.traceNodeCondition(true, "The V5QuerySet node is part of a metadata query and should be replaced.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The V5QuerySet node is not part of a metadata query and does not need replacing.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> xNodes = node.getDescendantsOfTypeOrdered(501025, false);
        IXQEQueryNode replacementNode = null;
        if (xNodes.isEmpty()) {
            xNodes = node.getDescendantsOfTypeOrdered(501021, false);
        }
        if (xNodes.isEmpty()) {
            xNodes = node.getDescendantsOfTypeOrdered(501053, false);
        }
        if (xNodes.isEmpty()) {
            xNodes = node.getDescendantsOfTypeOrdered(501017, false);
        }
        ArrayList<IXQEQueryNode> others = new ArrayList<IXQEQueryNode>();
        if (xNodes.size() > 0) {
            replacementNode = xNodes.get(0);
            if (node.getParent().getPropertyValue("multiQuery") != null) {
                for (int i = 1; i < xNodes.size(); ++i) {
                    others.add(xNodes.get(i).detach());
                }
            }
        }
        if (replacementNode != null) {
            node.exchange(replacementNode, false);
            IXQEQueryNode parent = replacementNode.getParent();
            for (IXQEQueryNode o : others) {
                parent.addChild(o);
            }
        }
    }
}

