/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XDimensionalStoreReference;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.querytemplates.AncestorQuery;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.tm1.SetTM1AliasTableMap;

public final class GenerateAncestorsSubQuery
extends Transformation {
    public GenerateAncestorsSubQuery() {
        this.mName = "Generate the ancestors' subquery node for the decoration of ragged compensation.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{501144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String dataSourceType;
        String errMsg = "xNodes.length == 0";
        XOLAPEdgeMapping xEdgeMappingNode = (XOLAPEdgeMapping)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ICube cube = xEdgeMappingNode.getCube();
        XMdx ancestorQueryXMDX = null;
        ancestorQueryXMDX = XOLAPEdgeMapping.isLolapQueryProviders(cube.getModelDataSource().getInterface()) ? (XMdx)nodeFactory.createXNode(501053) : (XMdx)nodeFactory.createXNode(501017);
        int[] types = new int[]{501017, 501053, 501095, 501158};
        IXQEQueryNode[] xNodes = xEdgeMappingNode.getDescendantsOfTypes(types, false);
        if (xNodes.length == 0) {
            xEdgeMappingNode.throwInternalError("xNodes.length == 0");
        }
        IXQEQueryNode xMdxNode = xNodes[0];
        int[] xmdxTypes = new int[]{501017, 501053};
        for (IXQEQueryNode eachNode : xNodes) {
            IXQEQueryNode aNode = eachNode;
            if (aNode.getType() == 501158) {
                IXQEQueryNode[] xmdxNodes = ((XDimensionalStoreReference)aNode).getReferencedDimStore().getDescendantsOfTypes(xmdxTypes, false);
                aNode = xmdxNodes[0];
            }
            if (aNode.getType() == 501017) {
                if (((XMdx)aNode).getMDXQuery() instanceof CustomQuery) continue;
                xMdxNode = aNode;
                break;
            }
            if (aNode.getType() != 501053 || ((XMdx)aNode).getMDXQuery() instanceof CustomQuery) continue;
            xMdxNode = aNode;
            break;
        }
        IAlias alias = null;
        if (xMdxNode.getType() == 501017) {
            XMdx xMdx = (XMdx)xMdxNode;
            ancestorQueryXMDX.setDataSource(xMdx.getDataSource());
            ancestorQueryXMDX.setCatalog(xMdx.getCatalog());
            ancestorQueryXMDX.setCube(cube.getName());
            if (xMdx.getMDXQuery().getDataSourceType().equals("TM") || xMdx.getMDXQuery().getDataSourceType().equals("TMR")) {
                alias = (IAlias)xMdx.getMDXQuery().getMDXFrom().getAlias();
            }
        } else if (xMdxNode.getType() == 501053) {
            XMdxLocal xMdxLocal = (XMdxLocal)xMdxNode;
            ancestorQueryXMDX.setDataSource(xMdxLocal.getDataSource());
            ancestorQueryXMDX.setCatalog(xMdxLocal.getCatalog());
            ancestorQueryXMDX.setCube(cube.getName());
            if (xMdxLocal.getMDXQuery().getDataSourceType().equals("TM") || xMdxLocal.getMDXQuery().getDataSourceType().equals("TMR")) {
                alias = (IAlias)xMdxLocal.getMDXQuery().getMDXFrom().getAlias();
            }
        }
        AncestorQuery ancestoryQuery = (AncestorQuery)CustomQueryFactory.createCustomQuery("AncestorQuery", cube);
        if (alias != null) {
            ancestoryQuery.setAliasTable(SetTM1AliasTableMap.generateAliasTable(environment, alias));
        }
        if (DataSourceTypeEnum.isTM1(dataSourceType = xEdgeMappingNode.getDataSource().getInterface()) || dataSourceType.equals("TMR")) {
            ancestoryQuery.setEscapeParameters(false);
            boolean bDataBaseOnly = false;
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (config != null) {
                bDataBaseOnly = config.getBooleanProperty("ForceDatabaseOnlyForPA", false);
            }
            boolean bl = bDataBaseOnly = bDataBaseOnly || environment.getMultiRequestContext().getRequestProcessing() == MultiRequestContext.RequestProcessing.DATABASEONLY;
            if (bDataBaseOnly) {
                ancestoryQuery.setRequestProcessing(MultiRequestContext.RequestProcessing.DATABASEONLY);
            }
        }
        ancestorQueryXMDX.setMDXQuery(ancestoryQuery);
        xEdgeMappingNode.setAncestorQuery(ancestorQueryXMDX);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        ICube cube;
        XQETrace trace = environment.getTrace();
        XOLAPEdgeMapping xEdgeMappingNode = (XOLAPEdgeMapping)node;
        boolean isAncestorsQueryRequired = xEdgeMappingNode.isAncestorsQueryRequired();
        if (isAncestorsQueryRequired && ((cube = xEdgeMappingNode.getCube()).getType() == ICube.CubeTypeEnum.DMR || cube.getType() == ICube.CubeTypeEnum.ROLAP)) {
            this.traceNodeCondition(false, "DMR/ROLAP queries never require ancestor queries.", trace);
            return false;
        }
        String theValueOf = "The value of '";
        String is = "' is '";
        String period = "'.";
        String ancestorsQueryRequired = "ancestorsQueryRequired";
        StringBuilder sb = new StringBuilder("The value of '");
        sb.append("ancestorsQueryRequired");
        sb.append("' is '");
        sb.append(isAncestorsQueryRequired);
        sb.append("'.");
        this.traceNodeCondition(isAncestorsQueryRequired, sb.toString(), trace);
        return isAncestorsQueryRequired;
    }
}

