/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyRowDecoration;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.decoration.OLAPEmptyRowDecorationRules;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEmptyRowDecoration;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.trace.XQETrace;

public final class GenerateXOLAPEmptyRowDecorationNode
extends Transformation {
    public GenerateXOLAPEmptyRowDecorationNode() {
        this.mName = "Generate The XOLAPEmptyRowDecoration node, the runtree node executing an OLAPEmptyRowDecoration.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{601012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XOLAPEmptyRowDecoration xNode = (XOLAPEmptyRowDecoration)nodeFactory.createXNode(501026);
        OLAPEmptyRowDecoration emptyRowDecoration = (OLAPEmptyRowDecoration)node;
        RSAPIEdgeRowset rsapiRowset = (RSAPIEdgeRowset)emptyRowDecoration.getRSAPIRowsetProperty();
        IHierarchy emptyRowSetDecoHier = emptyRowDecoration.getHierarchy();
        IXQEQueryNode[] xEdgeMappingNodes = emptyRowDecoration.getDescendantsOfType(501144, false);
        int[] edgeTupleOrdinals = GenerateXOLAPEmptyRowDecorationNode.getTupleEdgeOrdinals(rsapiRowset, emptyRowSetDecoHier, xEdgeMappingNodes);
        xNode.setEdgeOrdinal(edgeTupleOrdinals[0]);
        xNode.setTuplePosition(edgeTupleOrdinals[1]);
        IXQEQueryNode parent = null;
        do {
            IHierarchy parentEmptyDecoDecoHier;
            OLAPEmptyRowDecorationRules rules = (OLAPEmptyRowDecorationRules)environment.getRuleFactory().createRule(3);
            RSAPIEdgeRowset emptyRowset = (RSAPIEdgeRowset)emptyRowDecoration.getRSAPIRowsetProperty();
            rules.setEmptyRowset(emptyRowset);
            RSAPIEdgeRowset nearestRowset = emptyRowset.getGroupingRowset();
            rules.setRowset(nearestRowset);
            int dataItemIndex = -1;
            if (nearestRowset.getNumDataItems() > 0) {
                dataItemIndex = 0;
            }
            if (emptyRowDecoration.getSubType() == 101053) {
                rules.setEmptyRowType(OLAPEmptyRowDecorationRules.EmptyRowEnum.HEADER);
            } else if (emptyRowDecoration.getSubType() == 101052) {
                rules.setEmptyRowType(OLAPEmptyRowDecorationRules.EmptyRowEnum.FOOTER);
            }
            rules.setDataItemIndex(dataItemIndex);
            xNode.insertDecorationRules(0, rules);
            rules.setOwner(xNode);
            parent = emptyRowDecoration.getParent();
            if (parent == null || parent.getType() != 601012) continue;
            OLAPEmptyRowDecoration parentEmptyDeco = (OLAPEmptyRowDecoration)parent;
            RSAPIEdgeRowset parentEmptyDecoRowset = (RSAPIEdgeRowset)emptyRowDecoration.getRSAPIRowsetProperty();
            edgeTupleOrdinals = GenerateXOLAPEmptyRowDecorationNode.getTupleEdgeOrdinals(parentEmptyDecoRowset, parentEmptyDecoDecoHier = parentEmptyDeco.getHierarchy(), xEdgeMappingNodes);
            if (edgeTupleOrdinals[0] != xNode.getEdgeOrdinal() || edgeTupleOrdinals[1] != xNode.getTuplePosition()) continue;
            emptyRowDecoration.extract();
            emptyRowDecoration = parentEmptyDeco;
        } while (emptyRowDecoration == parent);
        parent.exchangeChildNode(emptyRowDecoration, xNode, true);
    }

    public static int[] getTupleEdgeOrdinals(RSAPIEdgeRowset rsapiRowset, IHierarchy hierarchy, IXQEQueryNode[] xEdgeMappingNodes) {
        int rsapiEdgeOrdinal;
        int[] edgeTupleOrdinals = new int[]{-1, -1};
        edgeTupleOrdinals[0] = rsapiEdgeOrdinal = rsapiRowset.getEdge().getOrdinal();
        if (xEdgeMappingNodes.length == 1) {
            edgeTupleOrdinals[0] = 0;
        }
        if (hierarchy != null && xEdgeMappingNodes.length > 0) {
            int tuplePosition = -1;
            for (IXQEQueryNode xEdgeMappingNode : xEdgeMappingNodes) {
                XOLAPEdgeMapping xOLAPEdgeMapping = (XOLAPEdgeMapping)xEdgeMappingNode;
                MDXHierInfo hierInfo = xOLAPEdgeMapping.getEdgeLevelInfo().getHierarchyInfo();
                if (!hierInfo.projectsHierarchy(hierarchy)) continue;
                if (xOLAPEdgeMapping.getEdgeOrdinal() != rsapiEdgeOrdinal) {
                    edgeTupleOrdinals[1] = xOLAPEdgeMapping.getEdgeOrdinal();
                }
                tuplePosition = hierInfo.getProjectedHierarchyIndex(hierarchy);
                if (rsapiRowset.getRefDataItem() != null || rsapiRowset.isFooterRowset() || rsapiRowset.isHeaderRowset() || tuplePosition + 1 < hierInfo.getNumProjectedHierarchies()) {
                    // empty if block
                }
                edgeTupleOrdinals[1] = ++tuplePosition;
                break;
            }
        }
        if (edgeTupleOrdinals[1] == -1) {
            edgeTupleOrdinals[1] = 0;
        }
        return edgeTupleOrdinals;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        OLAPEmptyRowDecoration decoNode = (OLAPEmptyRowDecoration)node;
        boolean bl = status = decoNode.getParent() != null;
        if (!status) {
            this.traceNodeCondition(status, "The OLAPEmptyRowDecoration has been processed already.", trace);
            return status;
        }
        decoNode.validateChildren();
        this.traceNodeCondition(status, "The transformation can be applyied upon the target OLAPEmptyRowDecoration.", trace);
        return status;
    }
}

