/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class GenerateJSONTableFunction
extends RQETransformation {
    private static final String EQUALS = "=";
    private static final String SEMICOLON = ";";

    public GenerateJSONTableFunction() {
        this.mName = "Generate JSONTable function specification.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        Map<String, Object> metadataProps;
        String apiType;
        QueryFormatter queryBuilder;
        XQENodeFactory factory = environment.getNodeFactory();
        IDataSource dataSource = ((SQLQueryNode)node).getDataSource();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLQueryItemList queryItems = qBlock.getQueryItemList();
        SQLTableFunction tblFunc = (SQLTableFunction)factory.createNode(301038);
        tblFunc.setSubType(SQLTableFunction.SubType.JSON_TABLE);
        tblFunc.setDataSource(dataSource);
        tblFunc.setQueryItemList(queryItems);
        tblFunc.setDataType(SQLBinderUtil.makeRowTypeFromQueryItems(queryItems));
        SQLProject projNode = (SQLProject)qBlock.getFirstDescendantOfTypeOrdered(301015, false);
        SQLRelation relation = (SQLRelation)projNode.getFirstDescendantOfTypeOrdered(301016, false);
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(environment.getExecutionEnvironment(), dataSource);
        AbstractConnection connection = (AbstractConnection)pooledConnection.getConnection();
        String connectionString = relation.getConnectionString();
        String[] tokens = connectionString.split(SEMICOLON);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String token : tokens) {
            if (!token.contains(EQUALS)) continue;
            String key = token.substring(0, token.indexOf(EQUALS));
            String value = token.substring(key.length() + 1);
            properties.put(key, value);
        }
        if (properties.get("PATH") == null) {
            properties.put("PATH", "$");
        }
        if ((queryBuilder = connection.getQueryBuilder(apiType = (String)(metadataProps = relation.getMetadataProperties()).get("APITYPE"), false)) != null) {
            qBlock.accept(queryBuilder, dataSource.getCapabilities());
            String resolvedQuery = GenerateJSONTableFunction.resolvePromptParameters(queryBuilder.bufferToString(), node, environment);
            connection.augmentQuery(properties, apiType, resolvedQuery);
        }
        JSONObject jObject = new JSONObject(properties);
        jObject.remove((Object)"UID");
        jObject.remove((Object)"PWD");
        jObject.remove((Object)"ASSEMBLY");
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(DataValueFactory.createObjectValue(jObject));
        tblFunc.addChild(literal);
        tblFunc.addChild(this.createLiteral(factory, (String)properties.get("PATH")));
        SQLValueList vList = projNode.getOutputList();
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            SQLFid fid = (SQLFid)vList.getChild(i);
            tblFunc.addChild(this.createLiteral(factory, fid.getJSONPathExpression()));
        }
        qBlock.exchange(tblFunc);
        connection = null;
        pooledConnection.returnConnection();
    }

    private static String resolvePromptParameters(String rawQuery, IXQEQueryNode node, IPlanningEnvironment environment) {
        if (rawQuery == null || rawQuery.isEmpty()) {
            return null;
        }
        StringBuilder resolvedQuery = new StringBuilder();
        IDataSource dataSource = ((SQLQueryNode)node).getDataSource();
        List<IXQEQueryNode> paramList = node.getDescendantsOfTypeOrdered(301051, 301004);
        Iterator<IXQEQueryNode> it = paramList.iterator();
        int offset = 0;
        while (it.hasNext()) {
            SQLParameter param = (SQLParameter)it.next();
            if (param.getModelFilterItem() == null) continue;
            ParameterInfo paramInfo = new ParameterInfo(param.getName());
            if (param.getValuePrefix() != null) {
                paramInfo.setValuePrefix(param.getValuePrefix());
            }
            if (param.getValueSuffix() != null) {
                paramInfo.setValueSuffix(param.getValueSuffix());
            }
            paramInfo.setUseParameterizedSQL(param.getUseParameterizedSQL());
            offset = GenerateJSONTableFunction.replaceParamNameWithValue(rawQuery, offset, resolvedQuery, paramInfo, environment, dataSource.getCapabilities());
        }
        resolvedQuery.append(rawQuery.substring(offset, rawQuery.length()));
        return resolvedQuery.toString();
    }

    private static int replaceParamNameWithValue(String rawQuery, int offset, StringBuilder resolvedQuery, ParameterInfo paramInfo, IPlanningEnvironment environment, IDataSourceCapabilities capabilities) {
        String paramName = String.format(":%s:", paramInfo.getName().replace(":", "::"));
        Parameter parameter = (Parameter)environment.getExecutionEnvironment().getMultiRequestContext().getRequestParameters().getParameters().get(paramInfo.getName());
        int indx = rawQuery.indexOf(paramName, offset);
        if (indx == -1) {
            throw new AssertionError((Object)"Non prompt parameter passed to JSONTable runtree node!");
        }
        resolvedQuery.append(rawQuery.substring(offset, indx));
        ParameterValues parameterValues = parameter.getParameterValueItems();
        if (parameter.isLiteral() && parameterValues.size() == 1) {
            resolvedQuery.append(parameterValues.getValueLiteral(paramInfo.getValuePrefix(), paramInfo.getValueSuffix(), capabilities));
        }
        offset = indx + paramName.length();
        return offset;
    }

    private SQLLiteral createLiteral(IXQENodeFactory factory, String value) {
        SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
        literal.setValue(DataValueFactory.createCharValue(value));
        return literal;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IDataSource dataSource = ((SQLQueryNode)node).getDataSource();
        boolean bl = status = ((SQLQueryBlock)node).isForeign() && dataSource != null && (DataSourceTypeEnum.isCloudant(dataSource.getType()) || DataSourceTypeEnum.isCouchDB(dataSource.getType()));
        if (status) {
            this.traceNodeCondition(status, "JSONTable function needs to be generated.", trace);
        } else {
            this.traceNodeCondition(status, "JSONTable function does not need to be generated.", trace);
        }
        return status;
    }
}

