/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XLiteral;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class GenerateXLiteral
extends RQETransformation {
    public GenerateXLiteral() {
        this.mName = "Generate XLiteral node.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{301031, 301050, 301067, 301068, 301070};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        GenerateXLiteral.doTransformation(node, environment);
    }

    static void doTransformation(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        Value value = null;
        XLiteral xNode = (XLiteral)nodeFactory.createXNode(501019);
        switch (node.getType()) {
            case 301031: {
                value = ((SQLLiteral)node).getValue();
                break;
            }
            case 301050: 
            case 301070: {
                value = DataValueFactory.createNullValue();
                break;
            }
            case 301067: {
                String name = ((SQLIdentifier)node).getName();
                value = DataValueFactory.createCharValue(name.length());
                value.set(name);
                break;
            }
            case 301068: {
                String option = ((SQLOption)node).getValue();
                value = DataValueFactory.createCharValue(option.length());
                value.set(option);
                break;
            }
        }
        xNode.setValue(value);
        xNode.setDataType(value.getDataType());
        node.exchange(xNode);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized() || node.getParent().getType() == 301040 && node.getGrandParent().getType() != 301076 || node.getParent().getType() == 301038 || node.getParent().getType() == 501154 || node.getAncestorOfType(301039) != null;
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }
}

