/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XProject;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public final class GenerateXProject
extends RQETransformation {
    public GenerateXProject() {
        this.mName = "Generate XProject node.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLProject pNode = (SQLProject)node;
        SQLValueList vList = (SQLValueList)pNode.getOutputList().detach();
        XProject xProject = (XProject)nodeFactory.createXNode(501011);
        XExpression[] outputList = new XExpression[vList.getNumberChildren()];
        System.arraycopy(vList.getChildren(), 0, outputList, 0, vList.getNumberChildren());
        for (int i = 0; i < outputList.length; ++i) {
            outputList[i].setParent(xProject);
        }
        List<SQLAlias> aliasList = vList.getAliasList();
        if (aliasList != null) {
            for (int i = 0; i < aliasList.size(); ++i) {
                SQLAlias alias = aliasList.get(i);
                if (alias == null) continue;
                outputList[i].setAlias(alias.getName());
            }
        }
        xProject.setContextNo(pNode.getContextNo());
        xProject.setOutputList(outputList);
        node.exchange(xProject, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLValueList list = ((SQLProject)node).getOutputList();
        IXQEQueryNode[] windows = list.getDescendantsOfType(301041, false);
        boolean bl = status = windows.length == 0;
        if (status) {
            this.traceQueryCondition(status, "Query block is a SQLProject query block.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is not a SQLProject query block.", trace);
        }
        return status;
    }
}

