/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPrettyPrintQueryFormatter;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.hooks.HookEvent;
import com.cognos.xqe.hooks.HookManager;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.rsapi.IRSAPIDataset;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.runtree.relational.GenerateXSql;
import com.cognos.xqe.util.FileHandler;
import java.util.List;
import java.util.Properties;

public class GenerateXSqlForSQLCall
extends RQETransformation {
    public GenerateXSqlForSQLCall() {
        this.mName = "Generate XCall node.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        String sqlQuery;
        SQLPrettyPrintQueryFormatter formatter;
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        qBlock.setName(null);
        SQLCall call = (SQLCall)qBlock.getChild(0);
        IXQEQueryNode[] children = call.getChildren();
        IDataSource dataSource = call.getDataSource();
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        XSql xNode = (XSql)factory.createXNode(501013);
        xNode.setDataSource(dataSource);
        Object reqEnv = environment.getRequestEnvironment();
        boolean doPrettyPrint = GenerateXSql.doPrettyPrint(node, environment);
        Properties props = new Properties();
        props.setProperty("nativeSQL", "true");
        String comments = null;
        IRSAPIDataset dataSet = (IRSAPIDataset)node.getAncestorOfType(401005);
        if (dataSet != null && null != (comments = dataSet.getSQLComments())) {
            comments = GenerateXSql.addDelimitersToComment(comments, capabilities);
        }
        if (doPrettyPrint) {
            formatter = new SQLPrettyPrintQueryFormatter(props);
            qBlock.accept(formatter, dataSource.getCapabilities());
            sqlQuery = ((Object)formatter).toString();
        } else {
            formatter = new SQLPlainQueryFormatter(props);
            qBlock.accept(formatter, dataSource.getCapabilities());
            sqlQuery = ((QueryFormatter)formatter).bufferToString();
        }
        xNode.setSqlText(sqlQuery);
        if (GenerateXSqlForSQLCall.isSQLFilePathSet(reqEnv)) {
            String sqlForSQLFile;
            if (doPrettyPrint) {
                sqlForSQLFile = sqlQuery;
            } else {
                SQLPrettyPrintQueryFormatter formatterForSQLFile = new SQLPrettyPrintQueryFormatter(props);
                qBlock.accept(formatterForSQLFile, dataSource.getCapabilities());
                sqlForSQLFile = ((Object)formatter).toString();
            }
            String path = reqEnv.getSqlFilePath();
            FileHandler.appendToFile(path, "\r\n\r\n\r\nNative SQL:\r\n");
            if (comments != null) {
                FileHandler.appendToFile(path, "\r\n");
                FileHandler.appendToFile(path, comments);
            }
            FileHandler.appendToFile(path, "\r\n");
            FileHandler.appendToFile(path, "\r\n");
            FileHandler.appendToFile(path, sqlForSQLFile);
        }
        List<IXQEQueryNode> params = node.getDescendantsOfTypeOrdered(301051, 301004);
        for (int i = 0; i < params.size(); ++i) {
            SQLParameter param = (SQLParameter)params.get(i);
            if (param.isOutParameter().booleanValue() || param.getName() == null) continue;
            ParameterInfo paramInfo = new ParameterInfo(param.getName());
            if (param.getValuePrefix() != null) {
                paramInfo.setValuePrefix(param.getValuePrefix());
            }
            if (param.getValueSuffix() != null) {
                paramInfo.setValueSuffix(param.getValueSuffix());
            }
            paramInfo.setUseParameterizedSQL(true);
            qBlock.addToParamInfoListForSubstitution(paramInfo);
        }
        xNode.setParamInfoListForSubstitution(qBlock.getParamInfoListForSubstitution());
        ConnectionParameters parameters = new ConnectionParameters();
        parameters.put(new DataSourceParameter(dataSource));
        parameters.put(new RunLocaleParameter(reqEnv.getRunLocale(), false));
        xNode.setStoredProcedureName(call.getName());
        xNode.setStoredProcedureSchema(call.getSchemaName());
        xNode.setStoredProcedureCatalog(call.getCatalogName());
        xNode.setStoredProcedureArguments(children);
        xNode.setUpdateSubject(call.isUpdateSubject());
        xNode.setCommentText(comments);
        if (HookManager.hooksDefined(HookEvent.JDBC_PREPARE)) {
            xNode.setSQLAst((SQLQueryNode)factory.deepCopyNodeNonIndexed(qBlock.getChild(0)));
        }
        node.exchange(xNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        boolean status = qBlock.getBlockType() == 301061;
        XQETrace trace = environment.getTrace();
        if (status) {
            SQLQueryBlock pQBlock = (SQLQueryBlock)qBlock.getAncestorOfType(301004);
            boolean bl = status = qBlock.isForeign() && (pQBlock == null || !pQBlock.isForeign());
        }
        if (status) {
            this.traceQueryCondition(status, "Query block is foreign.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is not foreign.", trace);
        }
        return status;
    }

    public static boolean isSQLFilePathSet(IRequestEnvironment environment) {
        String path = environment.getSqlFilePath();
        return path != null && !path.equals("");
    }
}

