/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPGroupBy;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.XVectorColumn;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorGroupBy;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;
import java.util.ArrayList;
import java.util.List;

public class GenerateXVectorGroupBy
extends RQEVectorTransformation {
    public GenerateXVectorGroupBy() {
        this.mName = "Generate XVectorGroupBy node.";
        this.mTypes = new int[]{901020};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XVectorGroupBy xNode = (XVectorGroupBy)factory.createXNode(501172);
        GenerateXVectorGroupBy.apply(node, xNode, factory);
    }

    /*
     * WARNING - void declaration
     */
    static void apply(IXQEQueryNode node, XVectorGroupBy xNode, XQENodeFactory factory) {
        int j;
        QEPGroupBy groupBy = (QEPGroupBy)node;
        SQLValueList vList = (SQLValueList)groupBy.getChild(1);
        SQLGroupByList gList = groupBy.getGroupByList();
        IXQEQueryNode[] origOutputList = vList.getChildren();
        int nGroupCols = 0;
        if (gList != null) {
            nGroupCols = gList.getNumberChildren();
        }
        int[] groupCols = new int[nGroupCols];
        for (int i = 0; i < nGroupCols; ++i) {
            if (((SQLQueryNode)gList.getChild(i)).getDataType().isBlob()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_GroupByNotAllowed);
            }
            if (gList.getChild(i).getType() != 301032) continue;
            SQLFid fid = (SQLFid)gList.getChild(i);
            groupCols[i] = fid.getVirtualColumnNo();
        }
        List<IXQEQueryNode> list = vList.getDescendantsOfTypeOrdered(501174, new int[]{501038, 501098});
        ArrayList<Integer> nonGroupingColumns = new ArrayList<Integer>();
        for (XVectorColumn xVectorColumn : list) {
            int columnNo = xVectorColumn.getColumnNo();
            boolean add = true;
            for (j = 0; j < groupCols.length; ++j) {
                if (columnNo != groupCols[j]) continue;
                add = false;
                break;
            }
            if (!add) continue;
            for (Integer integer : nonGroupingColumns) {
                if (integer != columnNo) continue;
                add = false;
                break;
            }
            if (!add) continue;
            nonGroupingColumns.add(new Integer(columnNo));
        }
        int[] nonGroupCols = new int[nonGroupingColumns.size()];
        if (nonGroupingColumns.size() > 0) {
            void var12_15;
            boolean bl = false;
            while (var12_15 < nonGroupCols.length) {
                nonGroupCols[var12_15] = (Integer)nonGroupingColumns.get((int)var12_15);
                ++var12_15;
            }
        }
        block5: for (int i = 0; i < list.size(); ++i) {
            boolean bl = false;
            XVectorColumn xColumn = (XVectorColumn)list.get(i);
            for (j = 0; j < groupCols.length; ++j) {
                if (xColumn.getColumnNo() != groupCols[j]) continue;
                xColumn.setColumnNo(j);
                bl = true;
                break;
            }
            for (j = 0; j < nonGroupCols.length && !bl; ++j) {
                if (xColumn.getColumnNo() != nonGroupCols[j]) continue;
                xColumn.setColumnNo(groupCols.length + j);
                continue block5;
            }
        }
        List<IXQEQueryNode> setFunctionList = vList.getDescendantsOfTypeOrdered(501038, false);
        XVectorSetFunction[] functionList = new XVectorSetFunction[setFunctionList.size()];
        setFunctionList.toArray(functionList);
        for (int i = 0; i < functionList.length; ++i) {
            XVectorColumn xColumn = (XVectorColumn)factory.createXNode(501174);
            xColumn.setContextNo(0);
            xColumn.setColumnNo(groupCols.length + nonGroupCols.length + i);
            xColumn.setDataType(functionList[i].getDataType());
            functionList[i].exchange(xColumn);
            IXQEQueryNode parent = xColumn.getParent();
            functionList[i].setParent(parent);
        }
        if (gList != null) {
            groupBy.detachChild(gList);
        }
        groupBy.detachChild(vList);
        XVectorExpression[] outputList = new XVectorExpression[vList.getNumberChildren()];
        System.arraycopy(vList.getChildren(), 0, outputList, 0, vList.getNumberChildren());
        for (int i = 0; i < origOutputList.length; ++i) {
            origOutputList[i].setParent(xNode);
        }
        xNode.setOutputList(outputList);
        xNode.setGroupByList(groupCols);
        xNode.setNonGroupByList(nonGroupCols);
        xNode.setFunctionList(functionList);
        xNode.setVectorizationContext(new XVectorContext(outputList.length));
        node.exchange(xNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLValueList vList = (SQLValueList)node.getChild(1);
        List<IXQEQueryNode> nonGroupingColumnList = vList.getDescendantsOfTypeOrdered(501174, new int[]{501038, 501098});
        boolean bl = status = ((QEPGroupBy)node).getGroupByList() != null || nonGroupingColumnList.size() != 0;
        if (status) {
            this.traceQueryCondition(status, "Vectorized group by operator can be generated.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized group by operator cannot be generated.", trace);
        }
        return status;
    }
}

