/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.VectorOp;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorLiteralNull;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;

public final class GenerateXVectorSearchedCase
extends RQEVectorTransformation {
    private static final int NARGS = 3;

    public GenerateXVectorSearchedCase() {
        this.mName = "Generate vectorized searched CASE operator.";
        this.mTypes = new int[]{301074};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int i;
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        IVectorContext dfNode = (IVectorContext)((Object)node.getAncestorOfCategory(301089));
        IDataType returnType = fNode.getDataType();
        XVectorContext vContext = dfNode.getVectorizationContext();
        Class<?> vClass = fNode.getVectorClass();
        node.getChild(0).extract();
        node.getChild(0).extract();
        IXQEQueryNode[] children = node.getChildren();
        boolean castRequired = returnType.isDecimal();
        for (i = 1; i < children.length && !castRequired; ++i) {
            castRequired = ((IValueExpression)children[i]).getDataType().isDecimal();
        }
        if (castRequired) {
            for (i = 1; i < node.getNumberChildren(); ++i) {
                IXQEQueryNode child = node.getChild(i);
                IDataType dType = ((IValueExpression)child).getDataType();
                if (dType.isNullType() || dType.exactlyEquivalent(returnType)) continue;
                Class<?> castClass = null;
                if (child.getType() != 301031) {
                    castClass = SQLCast.getVectorClass(dType, returnType);
                }
                XVectorContext.generateCast(environment, vContext, child, castClass, returnType);
            }
            children = node.getChildren();
        }
        Object[] arguments = new Object[3];
        for (int i2 = 0; i2 < children.length; ++i2) {
            arguments[i2] = this.getArgument(environment.getNodeFactory(), vContext, returnType, children[i2]);
        }
        XVectorExpression vExpr = XVectorContext.createVectorExpression(environment, vContext, vClass, VectorOp.SELECT, returnType, arguments);
        node.exchange(vExpr, true);
    }

    private Object getArgument(XQENodeFactory factory, XVectorContext vContext, IDataType dataType, IXQEQueryNode node) {
        Object argument;
        if (node.getType() == 301031) {
            argument = XVectorContext.getObjectForLiteral((SQLLiteral)node.detach());
        } else if (node.getType() == 301032) {
            argument = ((SQLFid)node.detach()).getVirtualColumnNo();
        } else if (node.getType() == 301050) {
            int columnNo = vContext.allocateOutputColumn(dataType);
            XVectorLiteralNull xNode = (XVectorLiteralNull)factory.createXNode(501176);
            xNode.setDataType(dataType);
            xNode.setOutputColumnNo(columnNo);
            node.exchange(xNode);
            argument = columnNo;
        } else {
            argument = ((XVectorExpression)node).getColumnNo();
        }
        return argument;
    }
}

