/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyDeMorgansLaws
extends Transformation {
    public ApplyDeMorgansLaws(int[] passNumbers) {
        this.mName = "Apply DeMorgan's Laws.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201003};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5LogicalExpression logicalOperator = (V5LogicalExpression)node.getChild(0);
        if (logicalOperator.getSubType() == 0) {
            logicalOperator.setSubType(1);
        } else {
            logicalOperator.setSubType(0);
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5LogicalExpression leftOperand = (V5LogicalExpression)nodeFactory.createNode(201003);
        leftOperand.setSubType(2);
        logicalOperator.getChild(0).insertParent(leftOperand);
        V5LogicalExpression rightOperand = (V5LogicalExpression)nodeFactory.createNode(201003);
        rightOperand.setSubType(2);
        logicalOperator.getChild(1).insertParent(rightOperand);
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int operatorType;
        XQETrace trace = environment.getTrace();
        if (((V5LogicalExpression)node).getSubType() != 2) {
            this.traceNodeCondition(false, "The V5LogicalExpression node is not a NOT operator.", trace);
            return false;
        }
        if ((node = node.getChild(0)).getType() == 201003 && ((operatorType = ((V5LogicalExpression)node).getSubType()) == 0 || operatorType == 1)) {
            this.traceNodeCondition(true, "The child node is an AND or OR operator.", trace);
            return true;
        }
        this.traceNodeCondition(true, "The child node is not an AND or OR operator.", trace);
        return false;
    }
}

