/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;

public final class BindV5RoleValue
extends Transformation {
    public BindV5RoleValue() {
        this.mName = "Bind V5 RoleValue function role type, data type, property metadata and MDX name.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{201098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BindV5RoleValue.bind(node);
    }

    public static void bind(IXQEQueryNode node) {
        V5RoleValueFunction roleValue = (V5RoleValueFunction)node;
        V5LiteralValue v = (V5LiteralValue)roleValue.getChild(0);
        RoleTypeEnum roleType = RoleTypeEnum.fromV5(v.getValue().toString());
        roleValue.setRoleType(roleType);
        roleValue.setDataType(roleType.getDataType());
        if ((roleType == RoleTypeEnum.MEMBER_CUSTOM_PROPERTY || roleType == RoleTypeEnum.BUSINESS_KEY || roleType.getDataType() == null) && roleValue.getNumberChildren() == 2) {
            V5QueryNode contextNode = (V5QueryNode)roleValue.getChild(1);
            MDXLevelInfo contextLevel = new MDXLevelInfo();
            ILevel level = null;
            IHierarchy hierarchy = null;
            MDXLevelInfo levelInfo = null;
            MDXHierInfo contextHier = contextNode.getHierarchyInfo();
            if (contextHier.getNumProjectedHierarchies() > 0) {
                hierarchy = contextHier.getProjectedHierarchy(0);
                contextLevel.addProjectedHierarchy(hierarchy);
                ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
                levelInfo = contextNode.getHierarchyLevelInfo(contextLevel, fncs);
                if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
                    contextNode.throwInternalError("Rolevalue's second child must project a single hierarchy.");
                }
                if (levelInfo.getNumProjectedLevels(hierarchy) == 1) {
                    level = levelInfo.getProjectedLevel(hierarchy, 0);
                }
            }
            String propertyName = ((V5LiteralValue)roleValue.getChild(0)).getValue().getString();
            IQueryItem property = null;
            boolean searchDone = false;
            if (level != null) {
                property = (IQueryItem)((Object)MetadataUtil.getPropertyByRole(level, propertyName));
                searchDone = true;
            } else if (hierarchy != null && hierarchy.isParentChild()) {
                property = (IQueryItem)((Object)MetadataUtil.getPropertyByRole(hierarchy.getLevel(0), propertyName));
                searchDone = true;
            }
            if (property != null) {
                roleValue.setPropertyMetadata(property);
            }
            if (!searchDone && levelInfo != null) {
                String mdxName = null;
                for (ILevel projectedLevel : levelInfo.getProjectedLevels(hierarchy)) {
                    IProperty levelProperty = MetadataUtil.getPropertyByRole(projectedLevel, propertyName);
                    if (levelProperty == null) {
                        mdxName = null;
                        break;
                    }
                    String levelPropertyName = levelProperty.getUniqueName();
                    if (mdxName == null) {
                        mdxName = levelPropertyName;
                        continue;
                    }
                    if (mdxName.equals(levelPropertyName)) continue;
                    mdxName = null;
                    break;
                }
                if (mdxName != null) {
                    roleValue.setMDXName(mdxName);
                }
            }
        }
        if (roleValue.getDataType() == null && roleValue.getNumberChildren() == 2) {
            if (roleValue.getPropertyMetadata() == null || roleValue.getPropertyMetadata().getDataType() == null) {
                roleValue.setDataType(StringType.DEFAULTSTRINGTYPE);
            } else {
                roleValue.setDataType(roleValue.getPropertyMetadata().getDataType());
            }
        }
        if (roleValue.getDataType() == null && roleValue.getPropertyMetadata() == null && roleValue.getNumberChildren() == 2) {
            roleValue.setDataType(StringType.DEFAULTSTRINGTYPE);
        }
    }

    public static IQueryItem bindPropertyMetadata(V5RoleValueFunction roleValue, IMetadata metadata, String propertyName) {
        IQueryItem property = null;
        if (MetadataType.isLevel(metadata)) {
            property = (IQueryItem)((Object)MetadataUtil.getPropertyByRole((ILevel)metadata, propertyName));
        } else if (((IHierarchy)metadata).isParentChild()) {
            property = (IQueryItem)((Object)MetadataUtil.getPropertyByRole(((IHierarchy)metadata).getLevel(0), propertyName));
        }
        roleValue.setPropertyMetadata(property);
        return property;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5RoleValueFunction roleValue = (V5RoleValueFunction)node;
        RoleTypeEnum roleType = roleValue.getRoleType();
        if (roleType == null) {
            this.traceNodeCondition(true, "The RoleValue function has no roleType.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The RoleValue function has a roleType.", trace);
        return false;
    }
}

