/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectV5Parameters
extends Transformation {
    public CollectV5Parameters(int[] passNumbers) {
        this.mName = "Collect V5Parameters.";
        this.mPassNumbers = passNumbers;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mTypes = new int[]{101002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Collection paramList = environment.getNodeIndex().getNodesByType(201024);
        HashMap<String, List<V5Parameter>> v5ParametersMap = new HashMap<String, List<V5Parameter>>();
        HashMap v5ParameterQueryMap = new HashMap();
        boolean isMasterDetail = false;
        for (V5Parameter v5Param : paramList) {
            String paramName = v5Param.getParameterName();
            String queryName = v5Param.getOriginalQueryName();
            if (!isMasterDetail) {
                isMasterDetail = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider().isDetailQuery(queryName);
            }
            if (v5ParametersMap.containsKey(paramName)) {
                ((List)v5ParametersMap.get(paramName)).add(v5Param);
                if (((List)v5ParameterQueryMap.get(paramName)).contains(queryName)) continue;
                ((List)v5ParameterQueryMap.get(paramName)).add(queryName);
                continue;
            }
            ArrayList<V5Parameter> paramListSameName = new ArrayList<V5Parameter>();
            paramListSameName.add(v5Param);
            v5ParametersMap.put(paramName, paramListSameName);
            ArrayList<String> queryNames = new ArrayList<String>();
            queryNames.add(queryName);
            v5ParameterQueryMap.put(paramName, queryNames);
        }
        V5QuerySet v5QuerySet = (V5QuerySet)node;
        v5QuerySet.setV5ParametersMap(v5ParametersMap);
        if (isMasterDetail) {
            int aSeverity = 1;
            for (Map.Entry entry : v5ParameterQueryMap.entrySet()) {
                String parameterName = (String)entry.getKey();
                List queryNames = (List)entry.getValue();
                Collections.sort(queryNames);
                if (queryNames == null || queryNames.isEmpty() || queryNames.size() <= 1) continue;
                StringBuilder queryNamesList = new StringBuilder();
                for (String queryName : queryNames) {
                    if (queryNamesList.length() > 0) {
                        queryNamesList.append(", ");
                    }
                    queryNamesList.append(queryName);
                }
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_MultiplePromptsWithSameName, parameterName, queryNamesList.toString()));
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        if (node.getParent() != null) {
            return false;
        }
        return status;
    }
}

