/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ConvertV5DataItemSortToV5ValueSetSort
extends Transformation {
    public static final String STRING_NONE = "none";

    public ConvertV5DataItemSortToV5ValueSetSort() {
        this.mName = "Convert sort associated with a V5DataItem to Sorted V5ValueSet";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101015, 101057};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String dataItemStr = null;
        V5ValueSet valueSet = null;
        if (node.getType() == 101015) {
            V5DataItemRef dataItemRef = (V5DataItemRef)node;
            dataItemStr = dataItemRef.getDataItemRefProperty();
            valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        } else {
            valueSet = (V5ValueSet)node;
            dataItemStr = valueSet.getRefDataItemProperty();
        }
        V5GroupBody groupBody = (V5GroupBody)node.getAncestorOfType(101051);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5Query query = qrd.getV5Query();
        V5DataItem v5DataItem = query.getV5Selection().getDataItemByRefName(dataItemStr);
        V5SortItem sortItem = (V5SortItem)nodeFactory.createNode(101056);
        sortItem.setPropertyValue("refDataItem", dataItemStr);
        String sortOrderStr = (String)v5DataItem.getPropertyValue("sort");
        sortItem.setPropertyValue("sortOrder", sortOrderStr);
        sortItem.setPropertyValue("sortType", "dataItemSort");
        V5ToCogMDXUtilities.addV5SortItemToProperValueSet(valueSet, groupBody, sortItem);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (qrd == null) {
            this.traceNodeCondition(false, "data item in sub-query.", trace);
            return false;
        }
        V5Query query = qrd.getV5Query();
        if (query.getPropertyValue("rootQueryName") != null) {
            this.traceNodeCondition(false, "Transformation should not apply to sub-query case.", trace);
            return false;
        }
        String dataItemStr = null;
        if (node.getType() == 101015) {
            V5DataItemRef dataItemRef = (V5DataItemRef)node;
            if (dataItemRef.getAncestorOfType(101051) == null) {
                this.traceNodeCondition(false, "No refDataItem associated with the groupBody.", trace);
                return false;
            }
            dataItemStr = dataItemRef.getDataItemRefProperty();
        } else {
            V5ValueSet v5ValueSet = (V5ValueSet)node;
            dataItemStr = v5ValueSet.getRefDataItemProperty();
        }
        if (dataItemStr == null) {
            this.traceNodeCondition(false, "No refDataItem associated with the valueSet.", trace);
            return false;
        }
        V5DataItem v5DataItem = query.getV5Selection().getDataItemByRefName(dataItemStr);
        Object sortProp = v5DataItem.getPropertyValue("sort");
        if (sortProp == null || sortProp.equals(STRING_NONE)) {
            this.traceNodeCondition(false, "No sort property associated with this data item.", trace);
            return false;
        }
        if (!v5DataItem.getIsProjected()) {
            this.traceNodeCondition(false, "Node is not projected.", trace);
            return false;
        }
        V5ValueSet valueSet = null;
        valueSet = node.getType() == 101015 ? (V5ValueSet)node.getAncestorOfType(101057) : (V5ValueSet)node;
        IXQEQueryNode[] sortItems = valueSet.getChildrenOfTypeOrdered(101056);
        for (int i = 0; i < sortItems.length; ++i) {
            if (!sortItems[i].getPropertyValue("refDataItem").equals(dataItemStr)) continue;
            this.traceNodeCondition(false, "There is a V5SortItem in the same value set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to propagate the sort from V5DataItem to its projected valueset.", trace);
        return true;
    }
}

