/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5Suppress;
import com.cognos.xqe.ast.localprocessing.v5.V5SuppressRule;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeSuppression;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5QueryTypeCheck;

public class ConvertV5EdgeSuppressionToV5Suppress
extends Transformation {
    public ConvertV5EdgeSuppressionToV5Suppress() {
        this.mName = "Create the local processing node V5Suppress.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101066};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean isSuppressed;
        if (node.getParent().getNumberChildren() == 1) {
            node.detach();
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5EdgeSuppression v5EdgeSuppression = (V5EdgeSuppression)node;
        Object nullsProp = v5EdgeSuppression.getPropertyValue("nulls");
        boolean isNulls = false;
        if (nullsProp != null) {
            String strNulls = nullsProp.toString();
            isNulls = strNulls.compareTo("true") == 0;
        }
        Object zeroProp = v5EdgeSuppression.getPropertyValue("zero");
        boolean isZero = false;
        if (zeroProp != null) {
            String strZero = zeroProp.toString();
            isZero = strZero.compareTo("true") == 0;
        }
        Object divByZeroProp = v5EdgeSuppression.getPropertyValue("divByZero");
        boolean isDivByZero = false;
        if (divByZeroProp != null) {
            String strDivByZero = divByZeroProp.toString();
            isDivByZero = strDivByZero.compareTo("true") == 0;
        }
        Object overflowProp = v5EdgeSuppression.getPropertyValue("overflow");
        boolean isOverflow = false;
        if (overflowProp != null) {
            String strOverflow = overflowProp.toString();
            isOverflow = strOverflow.compareTo("true") == 0;
        }
        boolean bl = isSuppressed = isNulls || isZero || isDivByZero || isOverflow;
        if (isSuppressed) {
            this.createLocalProcessingNode(node, nodeFactory, isNulls, isZero, isDivByZero, isOverflow);
        }
        node.extract();
    }

    private void createLocalProcessingNode(IXQEQueryNode node, IXQENodeFactory nodeFactory, boolean isNulls, boolean isZero, boolean isDivByZero, boolean isOverflow) {
        int edgeNum;
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        IXQEQueryNode topNode = rsapiDataset.getChild(0);
        V5Suppress localProcessingNode = (V5Suppress)node.getAncestorOfType(601022);
        if (localProcessingNode == null) {
            localProcessingNode = (V5Suppress)nodeFactory.createNode(601022);
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)rsapiDataset.getFirstChildByType(101055);
            if (qrd != null && V5QueryTypeCheck.isRelationalQuery(qrd)) {
                rsapiDataset.addChild(localProcessingNode);
            } else {
                topNode.insertParent(localProcessingNode);
            }
            if (qrd != null) {
                for (IXQEQueryNode valueSetNode : qrd.getDescendantsOfType(101057, false)) {
                    V5ValueSet valueSet = (V5ValueSet)valueSetNode;
                    if (!valueSet.isSpacerNoCellValue()) continue;
                    localProcessingNode.setCheckForSpacers(true);
                    break;
                }
            }
        }
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        String sEdge = edge.getPropertyValue("name").toString();
        for (edgeNum = 0; edgeNum < rsapiDataset.getNumEdges() && !rsapiDataset.getEdge(edgeNum).getName().equals(sEdge); ++edgeNum) {
        }
        V5SuppressRule rule = (V5SuppressRule)nodeFactory.createNode(601023);
        rule.setEdgeNum(edgeNum);
        rule.setEdgeName(sEdge);
        rule.setNulls(isNulls);
        rule.setZero(isZero);
        rule.setDivByZero(isDivByZero);
        rule.setOverflow(isOverflow);
        localProcessingNode.addChild(rule);
        if (isNulls) {
            edge.setNullVisualSuppression();
        }
        if (isZero) {
            edge.setZeroVisualSuppression();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!this.isLocalSuppressionConfigurationEnabled(environment)) {
            this.traceQueryCondition(false, "Local suppression is not enabled", trace);
            return false;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        if (rsapiDataset == null) {
            this.traceQueryCondition(false, "No rsapiDataset node is found.", trace);
            return false;
        }
        this.traceNodeCondition(true, "A V5Suppress local processing node  is created.", trace);
        return true;
    }

    private boolean isLocalSuppressionConfigurationEnabled(PlanningEnvironment environment) {
        return environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.suppression.local[@enabled]", true);
    }
}

