/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Set;

public final class DetectCircularReferencingQueries
extends Transformation {
    public DetectCircularReferencingQueries(int passNumber) {
        this.mName = "Detect Circular Referencing Queries";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101002};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(true, "Always apply.", trace);
        return true;
    }

    public void checkCircularReference(V5Query query, LoopDetectionChain ldc, V5QuerySet querySet, PlanningEnvironment environment) {
        if (!ldc.push(query.getV5QueryName())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInQuery, ldc.serialize());
        }
        Set<String> refQueries = query.getSubQueryNames(environment);
        for (String refQuery : refQueries) {
            if (refQuery == null || refQuery.isEmpty()) continue;
            V5Query subQuery = querySet.getV5Query(refQuery);
            if (subQuery == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidQueryRef, query.getV5QueryName(), refQuery);
            }
            this.checkCircularReference(subQuery, ldc, querySet, environment);
        }
        ldc.pop();
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node;
        IXQEQueryNode[] qrds = querySet.getDescendantsOfType(101055, true);
        LoopDetectionChain ldc = new LoopDetectionChain();
        for (IXQEQueryNode current : qrds) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)current;
            V5Query query = qrd.getV5Query();
            if (query == null) continue;
            this.checkCircularReference(query, ldc, querySet, environment);
        }
        querySet.setPropertyValue("loopChecked", Boolean.TRUE);
    }
}

