/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class DetectInvalidV5DataItemWithAggNotApplicable
extends Transformation {
    public DetectInvalidV5DataItemWithAggNotApplicable() {
        this.mName = "DetectInvalidV5DataItemWithAggNotApplicable";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem dataItem = (V5DataItem)node;
        throw new XQERuntimeException(XQEMessageKeys.PLN_AggrNotApplicableMayContainOnlyDataItemReferences, dataItem.getNameProperty());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem dataItem = (V5DataItem)node;
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null) {
            this.traceQueryCondition(false, "The V5 expression is not within a V5Query.", trace);
            return false;
        }
        String aggregateName = dataItem.getAggregateProperty();
        if (aggregateName == null) {
            this.traceQueryCondition(false, "The aggregate attribute is not defined.", trace);
            return false;
        }
        if (!aggregateName.equals("notApplicable")) {
            this.traceQueryCondition(false, "The aggregate attribute of the data item is different from 'notApplicable'.", trace);
            return false;
        }
        if (!query.isTabular() && !query.isRelStyle()) {
            this.traceNodeCondition(false, "The query of the reference is not tabular and not relStyle.", trace);
            return false;
        }
        List<IXQEQueryNode> allV5BoundModelIds = dataItem.getDescendantsOfTypeOrdered(201116, false);
        for (IXQEQueryNode v5BoundModelId : allV5BoundModelIds) {
            if (!this.belongsToCurrentDataItem(v5BoundModelId, dataItem)) continue;
            this.traceQueryCondition(true, "The expression of the data item contains 3-part names.", trace);
            return true;
        }
        List<IXQEQueryNode> allV5BoundDataItemRefs = dataItem.getDescendantsOfTypeOrdered(201060, false);
        String queryNameOfInputNode = query.getV5QueryName();
        for (IXQEQueryNode v5BoundDataItemRef : allV5BoundDataItemRefs) {
            V5DataItem refDataItem;
            V5Query queryOfRefDataItem;
            String queryNameOfRefDataItem;
            V5BoundDataItemReference boundDataItemRef = (V5BoundDataItemReference)v5BoundDataItemRef;
            if (!this.belongsToCurrentDataItem(boundDataItemRef, dataItem) || (queryNameOfRefDataItem = (queryOfRefDataItem = (V5Query)(refDataItem = boundDataItemRef.getRefDataItem()).getAncestorOfType(101006)).getV5QueryName()).equals(queryNameOfInputNode)) continue;
            this.traceQueryCondition(true, "The expression of the data item contains a reference to a data item in another query.", trace);
            return true;
        }
        return false;
    }

    private boolean belongsToCurrentDataItem(IXQEQueryNode node, V5DataItem currentDataItem) {
        V5DataItem ancestorDataItem = (V5DataItem)node.getAncestorOfType(101003);
        return ancestorDataItem == currentDataItem;
    }
}

