/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Set;

public final class ExpandDataItemReferences
extends Transformation {
    public ExpandDataItemReferences(int[] passNumbers) {
        this.mName = "Expand data item references.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201060};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ExpandDataItemReferences.processNode(node, environment);
    }

    public static void processNode(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode origExpr;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
        V5DataItem refDataItem = dataItemRef.getRefDataItem();
        String[] parts = (String[])dataItemRef.getPropertyValue("nameParts");
        String queryName = dataItemRef.getIdentifier();
        if (parts != null && parts.length > 0) {
            queryName = parts[0];
        }
        ExpandDataItemReferences.findCircularReference(queryName, dataItemRef, dataItemRef.getIdentifier());
        V5DataItem newDataItem = (V5DataItem)nodeFactory.deepCopyNode(refDataItem);
        newDataItem.setOriginalV5DataItem(refDataItem);
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (dataItemRef.isQueryRefItem()) {
            Set<String> st;
            V5Source src;
            newDataItem.setPropertyValue("orgDefined", dataItemRef.getIdentifier());
            if (!(query == null || (src = query.getV5Source()) == null || (st = src.getReferencedQueries()) != null && st.contains(queryName))) {
                newDataItem.setPropertyValue("subQueryDataItemRef", Boolean.TRUE);
            }
        }
        if (ExpandDataItemReferences.generateSubqueryForCalc(node, environment) && (origExpr = refDataItem.getCalculationExpression()) != null) {
            query.addExpandedCalculation((V5BoundDataItemReference)node, origExpr);
        }
        node.exchange(newDataItem);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null) {
            this.traceQueryCondition(false, "The V5 expression is not within a V5Query.", trace);
            return false;
        }
        V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
        if (dataItem != null && dataItem.getPropIsRollupExpression()) {
            this.traceQueryCondition(false, "The V5 expression is a rollupExpression.", trace);
            return false;
        }
        V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
        if (dataItemRef.isQueryRefItem()) {
            if (query.getV5Source().getFirstDescendantOfTypeOrdered(101019, false) != null) {
                this.traceNodeCondition(false, "The query of the reference is based on a join operation.", trace);
                return false;
            }
            if (query.isTabular() || query.isRelStyle() || query.getForcedDMRToRelational()) {
                this.traceNodeCondition(false, "The query of the reference is tabular.", trace);
                return false;
            }
        }
        this.traceQueryCondition(true, "The data item reference can be replaced with the referenced data item.", trace);
        return true;
    }

    private static void findCircularReference(String queryName, V5BoundDataItemReference dataItemRef, String identifier) {
        IXQEQueryNode parent;
        LoopDetectionChain ldc1 = new LoopDetectionChain();
        ldc1.push(identifier);
        for (parent = dataItemRef.getParent(); parent != null && parent.getType() != 101009; parent = parent.getParent()) {
            V5DataItem di;
            if (parent.getType() != 101003 || (di = (V5DataItem)parent).getPropertyValue("orgDefined") == null || ldc1.push((String)di.getPropertyValue("orgDefined"))) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, queryName, ldc1.serialize());
        }
        V5DataItem referencedDataItem = dataItemRef.getRefDataItem();
        LoopDetectionChain ldc2 = new LoopDetectionChain();
        String firstName = null;
        for (parent = dataItemRef.getParent(); parent != null && parent.getType() != 101009; parent = parent.getParent()) {
            if (parent.getType() != 101003) continue;
            V5DataItem di = (V5DataItem)parent;
            if (firstName == null) {
                firstName = di.getNameProperty();
            }
            ldc2.push(di.getNameProperty());
            if (referencedDataItem != di) continue;
            ldc2.push(firstName);
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, queryName, ldc2.serialize());
        }
    }

    public static boolean generateSubqueryForCalc(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean subqueryForCalcsSetting;
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        Governors gov = querySet.getGovernorOfRetrieveDatasetV5Query();
        if (gov != null && (subqueryForCalcsSetting = gov.getGenerateSubqueryForCalcs()) != null) {
            return subqueryForCalcsSetting;
        }
        return environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.generateSubqueryForCalcs[@enabled]", false);
    }
}

