/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import java.util.HashSet;
import java.util.List;

public final class GenerateTabularStreamForLocalV5Pivot
extends Transformation {
    public GenerateTabularStreamForLocalV5Pivot() {
        this.mName = "Generate V5Pivot for xtab on Tabular Stream.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String reqType = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName();
        boolean bOptimize = false;
        if (reqType != null && reqType.equals("getParameters")) {
            V5Query query = ((V5QueryResultDefinition)node).getV5Query();
            boolean bl = bOptimize = !query.isOLAPConstruct();
        }
        if (bOptimize) {
            this.turnXtabToList(nodeFactory, node);
        } else {
            this.generateV5Pivot(nodeFactory, node);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String reqType;
        V5Query v5Query;
        V5Source v5Source;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        if (!v5QRD.isList() && (v5Source = (v5Query = v5QRD.getV5Query()).getV5Source()) != null && Boolean.TRUE == v5Source.getPropertyValue("needTabularStream") && v5Query.isRelStyle() && (reqType = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName()) != null && reqType.equals("getParameters")) {
            V5Query query = ((V5QueryResultDefinition)node).getV5Query();
            boolean bl = status = !query.isOLAPConstruct();
        }
        if (status) {
            this.traceNodeCondition(status, "need to generate V5Pivot for xtab on tabular stream.", trace);
        } else {
            this.traceNodeCondition(status, "don't need local V5Pivot for xtab on tabular stream.", trace);
        }
        return status;
    }

    protected void turnXtabToList(IXQENodeFactory nodeFactory, IXQEQueryNode v5QRD) {
        String refQuery = ((V5QueryResultDefinition)v5QRD).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)v5QRD.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        v5Query.setPropertyValue("isTabular", Boolean.TRUE);
        V5Selection selection = v5Query.getV5Selection();
        RSAPIDataset rsapiDataset = (RSAPIDataset)v5QRD.getAncestorOfType(401005);
        HashSet<String> v5DataItems = new HashSet<String>();
        List<IXQEQueryNode> v5ValueSets = v5QRD.getDescendantsOfTypeOrdered(101057, false);
        for (IXQEQueryNode eValueSet : v5ValueSets) {
            IXQEQueryNode[] sorts;
            IXQEQueryNode[] groupBodys;
            V5ValueSet v5ValueSet = (V5ValueSet)eValueSet;
            String dataItem = v5ValueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = selection.getDataItemByRefName(dataItem);
            if (v5DataItem != null && !v5DataItem.isOLAPConstruct()) {
                v5DataItems.add(dataItem);
            }
            for (IXQEQueryNode aBody : groupBodys = v5ValueSet.getChildrenOfType(101051)) {
                IXQEQueryNode[] refItems;
                V5GroupBody groupBody = (V5GroupBody)aBody;
                for (IXQEQueryNode aItem : refItems = groupBody.getChildrenOfType(101015)) {
                    V5DataItemRef ref = (V5DataItemRef)aItem;
                    String refName = ref.getDataItemRefProperty();
                    v5DataItem = selection.getDataItemByRefName(refName);
                    if (v5DataItem == null || v5DataItem.isOLAPConstruct()) continue;
                    v5DataItems.add(refName);
                }
            }
            for (IXQEQueryNode aSort : sorts = v5ValueSet.getChildrenOfType(101056)) {
                String refName = ((V5SortItem)aSort).getRefDataItem();
                v5DataItem = selection.getDataItemByRefName(refName);
                if (v5DataItem == null || v5DataItem.isOLAPConstruct()) continue;
                v5DataItems.add(refName);
            }
        }
        v5QRD.detachChildren();
        v5QRD.detach();
        RSAPIDataset dataset = (RSAPIDataset)nodeFactory.createNode(401005);
        dataset.setName(rsapiDataset.getName());
        dataset.setRefQueryName(rsapiDataset.getRefQueryName());
        dataset.setGovernors(rsapiDataset.getGovernors());
        dataset.setOptimizeForAllRows(false);
        dataset.setUseSAPMUNAsBusinessKey(rsapiDataset.isUseSAPMUNAsBusinessKey());
        dataset.addChild(v5QRD);
        rsapiDataset.exchange(dataset);
        IXQEQueryNode edge = nodeFactory.createNode(101049);
        ((V5Edge)edge).setEdgeID(0);
        edge.setPropertyValue("name", "1");
        v5QRD.addChild(edge);
        IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
        valueSet.setNameProperty("3");
        valueSet.setIsReportDetail(Boolean.TRUE);
        edgeGroup.addChild(valueSet);
        IXQEQueryNode groupBody = nodeFactory.createNode(101051);
        groupBody.setPropertyValue("name", "3_gb");
        groupBody.setPropertyValue("RSAPIInfoCollected", Boolean.TRUE);
        valueSet.addChild(groupBody);
        RSAPIEdge rsapiEdge = new RSAPIEdge();
        rsapiEdge.setName((String)edge.getPropertyValue("name"));
        int edgeId = ((V5Edge)edge).getEdgeID();
        rsapiEdge.setOrdinal(edgeId);
        edge.setPropertyValue("RSAPIEdge", rsapiEdge);
        rsapiEdge.setDataset(dataset);
        dataset.addEdge(rsapiEdge);
        RSAPIEdgeRowset rowset = new RSAPIEdgeRowset();
        Boolean bNoDataMode = v5QuerySet.getBooleanPropertyValue(V5QuerySet.RequestHint.NO_DATA_MODE.getPropertyName());
        if (null != bNoDataMode) {
            rowset.setNoDataMode(bNoDataMode);
        }
        valueSet.setRSAPIEdgeRowset(rowset);
        rowset.setName((String)valueSet.getPropertyValue("name"));
        rowset.setRowsetId(0);
        rowset.setEdge(rsapiEdge);
        rsapiEdge.addRowset(rowset);
        rsapiEdge.setRootRowset(rowset);
        int i = 0;
        for (String dataItem : v5DataItems) {
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItem);
            groupBody.addChild(dataItemRef);
            rowset.setDataItem(i, RSAPIUtilities.transferV5DataItemToRSAPIDataItem((V5DataItemRef)dataItemRef, selection, true));
            ++i;
        }
        dataset.validateReportLayout();
    }

    protected void generateV5Pivot(IXQENodeFactory nodeFactory, IXQEQueryNode v5QRD) {
    }
}

