/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.result.V5DetailContext;
import com.cognos.xqe.ast.v5.result.V5MasterContext;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.MDOLogger;

public class ProcessMasterDetailLinks
extends Transformation {
    public ProcessMasterDetailLinks() {
        this.mName = "Process master-detail links.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101059};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        if (linkNode.getMDProviderLink() != null) {
            this.traceQueryCondition(false, "The node has been processed already.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 101055) {
            this.traceQueryCondition(false, "The master query name could not be found.", trace);
            return false;
        }
        String masterQrdName = null;
        String detailQrdName = null;
        IXQEQueryNode[] children = node.getChildrenOfTypes(new int[]{101060, 101061});
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getType() == 101060) {
                masterQrdName = ((V5MasterContext)children[i]).getRefQueryResultDefinition();
                continue;
            }
            detailQrdName = ((V5DetailContext)children[i]).getRefQueryResultDefinition();
        }
        if (masterQrdName == null || detailQrdName == null) {
            this.traceQueryCondition(false, "The master-detail link does not refer to the valid query result definitions.", trace);
            return false;
        }
        boolean hasMasterQrd = false;
        boolean hasDetailQrd = false;
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        IXQEQueryNode[] qrds = querySet.getDescendantsOfType(101055, true);
        for (int i = 0; i < qrds.length; ++i) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)qrds[i];
            String qrdName = (String)qrd.getPropertyValue("name");
            if (qrdName.equals(masterQrdName) && querySet.getV5Query(qrd.getRefQueryProperty()) != null) {
                hasMasterQrd = true;
            }
            if (!qrdName.equals(detailQrdName) || querySet.getV5Query(qrd.getRefQueryProperty()) == null) continue;
            hasDetailQrd = true;
        }
        if (!hasMasterQrd || !hasDetailQrd) {
            this.traceQueryCondition(false, "The master-detail link is invalid.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The query has a valid master-detail link.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getParent();
        String linkName = mdProvider.addLink(qrd, linkNode, querySet);
        MasterDetailLink link = mdProvider.getLink(linkName);
        linkNode.setMDProviderLink(link);
        MDOLogger.logMDOFeedback(environment, linkNode, link);
    }
}

