/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class ReSetParentMasterDetailLink
extends Transformation {
    public ReSetParentMasterDetailLink() {
        this.mName = "Re-set the parameter parent link for links.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101059};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        MasterDetailLink link = linkNode.getMDProviderLink();
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        List<MasterDetailLink> parentlinks = mdProvider.getMasterDetailLinksForDetailQrd(link.getMasterQrdName());
        for (MasterDetailLink parentLink : parentlinks) {
            if (!parentLink.isParameterLink()) continue;
            V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
            V5Query masterQuery = querySet.getV5Query(link.getMasterQueryName());
            V5DataItem linkItem = parentLink.getV5DataItemFromQuery(masterQuery);
            mdProvider.setParentMDLink(link, linkItem.getNameProperty());
        }
        linkNode.setPropertyValue("parameterParentLinkReProcessed", true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        if (node.getBooleanPropertyValue("parameterParentLinkReProcessed") != null) {
            this.traceQueryCondition(false, "The parameter parent link is already set.", trace);
            return false;
        }
        MasterDetailLink link = linkNode.getMDProviderLink();
        if (link == null || link.getParentMDLink() != null) {
            this.traceQueryCondition(false, "The parent link of this link is already set.", trace);
            return false;
        }
        String masterQrdName = link.getMasterQrdName();
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        List<MasterDetailLink> parentlinks = mdProvider.getMasterDetailLinksForDetailQrd(masterQrdName);
        if (parentlinks != null) {
            for (MasterDetailLink parentLink : parentlinks) {
                V5Query masterQuery;
                V5DataItem linkItem;
                if (!parentLink.isParameterLink()) continue;
                V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
                if (querySet == null) {
                    node.throwInternalError("The master detail link node should be in a querySet");
                }
                if ((linkItem = parentLink.getV5DataItemFromQuery(masterQuery = querySet.getV5Query(link.getMasterQueryName()))) == null) continue;
                this.traceQueryCondition(true, "The parent link is a parameter link. Need to reset the parent link after parsing", trace);
                return true;
            }
        }
        this.traceQueryCondition(false, "No need to set the parent link.", trace);
        return false;
    }
}

