/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ResolveDataItemReferenceAutomaticAggregate;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;

public final class RefineAutomaticXtab
extends Transformation {
    protected static final String[] NONE_V5 = new String[]{"none"};
    protected static final String[] NONE_MODEL = new String[]{"unsupported"};
    protected static final String[] AUTOMATIC_V5 = new String[]{"automatic"};
    protected static final String[] AUTOMATIC_MODEL = new String[]{"automatic", "unknown"};
    protected static final String[] SUMMARIZE_V5 = new String[]{"summarize"};
    protected static final String[] SUMMARIZE_MODEL = new String[0];
    protected static final String[] TOTAL_V5 = new String[]{"total"};
    protected static final String[] TOTAL_MODEL = new String[]{"sum"};
    protected static final String[] MIN_V5 = new String[]{"minimum"};
    protected static final String[] MIN_MODEL = new String[]{"minimum"};
    protected static final String[] MAX_V5 = new String[]{"maximum"};
    protected static final String[] MAX_MODEL = new String[]{"maximum"};
    protected static final String[] AVG_V5 = new String[]{"average"};
    protected static final String[] AVG_MODEL = new String[]{"average"};
    protected static final String[] COUNT_V5 = new String[]{"count"};
    protected static final String[] COUNT_MODEL = new String[]{"count"};
    protected static final String[] CALCULATED_V5 = new String[]{"calculated", "notApplicable"};
    protected static final String[] CALCULATED_MODEL = new String[]{"calculated", "countNonZero"};
    protected static final String[] COUNTDISTINCT_V5 = new String[]{"countDistinct"};
    protected static final String[] COUNTDISTINCT_MODEL = new String[]{"countDistinct"};
    protected static final String[] STDDEV_V5 = new String[]{"standardDeviation"};
    protected static final String[] STDDEV_MODEL = new String[]{"standardDeviation"};
    protected static final String[] VARIANCE_V5 = new String[]{"variance"};
    protected static final String[] VARIANCE_MODEL = new String[]{"variance"};
    protected static final String[] MEDIAN_V5 = new String[]{"median"};
    protected static final String[] MEDIAN_MODEL = new String[]{"median"};
    protected static final String[] NOTAPP_V5 = new String[]{"notApplicable"};
    protected static final String[] NOTAPP_MODEL = new String[0];

    public RefineAutomaticXtab() {
        this.mName = "Refine the automatic aggregate and rollup aggregate type in Xtab.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem = (V5DataItem)node;
        String aggr = v5DataItem.getAggregateProperty();
        String rollUp = v5DataItem.getRollupAggregateProperty();
        AggrTypeEnum aggrType = AggrTypeEnum.valueOfV5String(aggr);
        AggrTypeEnum rollUpType = AggrTypeEnum.valueOfV5String(rollUp);
        if (aggrType == AggrTypeEnum.AUTOMATIC || aggrType == AggrTypeEnum.SUMMARIZE) {
            aggrType = RefineAutomaticXtab.determineAggrType(environment, node.getChild(0), aggrType);
            if (aggrType == AggrTypeEnum.NONE && rollUpType != AggrTypeEnum.NONE && rollUpType != AggrTypeEnum.AUTOMATIC) {
                aggrType = AggrTypeEnum.CALCULATED;
            }
            v5DataItem.setAggregateProperty(aggrType.v5StringType[0]);
        }
        if (rollUpType == AggrTypeEnum.AUTOMATIC || rollUpType == AggrTypeEnum.SUMMARIZE) {
            v5DataItem.setPropertyValue("orgRollupAggregate", rollUp);
            IXQEQueryNode v5Query = v5DataItem.getAncestorOfType(101006);
            rollUpType = v5Query.getPropertyValue("queryUsesBridge") != Boolean.TRUE ? RefineAutomaticXtab.determineRoolupAggrType(aggrType, rollUpType) : AggrTypeEnum.CALCULATED;
            v5DataItem.setRollupAggregateProperty(rollUpType.v5StringType[0]);
        }
    }

    public static AggrTypeEnum determineRoolupAggrType(AggrTypeEnum aggrType, AggrTypeEnum rollUpType) {
        if (rollUpType.explicitAggr || rollUpType == AggrTypeEnum.NONE || rollUpType == AggrTypeEnum.CALCULATED) {
            return rollUpType;
        }
        if (rollUpType == AggrTypeEnum.AUTOMATIC) {
            if (aggrType == AggrTypeEnum.NONE || aggrType == AggrTypeEnum.AUTOMATIC) {
                return AggrTypeEnum.NONE;
            }
            if (aggrType.explicitAggr || aggrType == AggrTypeEnum.CALCULATED) {
                if (aggrType == AggrTypeEnum.TOTAL || aggrType == AggrTypeEnum.MIN || aggrType == AggrTypeEnum.MAX) {
                    return aggrType;
                }
                if (aggrType == AggrTypeEnum.COUNT) {
                    return AggrTypeEnum.TOTAL;
                }
                return AggrTypeEnum.CALCULATED;
            }
            return AggrTypeEnum.MIN;
        }
        if (aggrType.explicitAggr) {
            return aggrType;
        }
        return AggrTypeEnum.MIN;
    }

    public static AggrTypeEnum determineAggrType(PlanningEnvironment environment, IXQEQueryNode node, AggrTypeEnum aggrType) {
        AggrTypeEnum rtAggrType = AggrTypeEnum.NONE;
        if (node.getType() == 101004) {
            IXQEQueryNode[] children = node.getChildren();
            if (children.length != 1) {
                return rtAggrType;
            }
            node = children[0];
        }
        if (aggrType == AggrTypeEnum.AUTOMATIC && (aggrType = RefineAutomaticXtab.determineDefaultExpressionAggregation(environment, node, null)) != AggrTypeEnum.SUMMARIZE) {
            return aggrType;
        }
        if (aggrType == AggrTypeEnum.SUMMARIZE) {
            rtAggrType = RefineAutomaticXtab.resolveSummarized(environment, node);
        } else if (aggrType == AggrTypeEnum.CALCULATED) {
            if (node.getType() != 101003 && node.getNumberChildren() > 0) {
                rtAggrType = aggrType;
            } else {
                rtAggrType = RefineAutomaticXtab.determineExpressionLeafAggregation(environment, node, null);
                if (rtAggrType == AggrTypeEnum.NONE) {
                    rtAggrType = AggrTypeEnum.MIN;
                }
            }
        } else {
            rtAggrType = aggrType;
        }
        return rtAggrType;
    }

    protected static AggrTypeEnum determineDefaultExpressionAggregation(PlanningEnvironment environment, IXQEQueryNode node, IXQEQueryNode contextParentExprNode) {
        AggrTypeEnum rtAggrType = AggrTypeEnum.NONE;
        if (node.isOfCategory(201124)) {
            return AggrTypeEnum.CALCULATED;
        }
        if (node.getType() == 101003 || node.getNumberChildren() == 0) {
            return RefineAutomaticXtab.determineExpressionLeafAggregation(environment, node, contextParentExprNode);
        }
        IXQEQueryNode[] children = node.getChildren();
        for (int iChild = 0; iChild < children.length; ++iChild) {
            AggrTypeEnum childAggrType = RefineAutomaticXtab.determineDefaultExpressionAggregation(environment, children[iChild], node);
            if (childAggrType == AggrTypeEnum.CALCULATED) {
                return AggrTypeEnum.CALCULATED;
            }
            if (childAggrType != AggrTypeEnum.SUMMARIZE && !childAggrType.explicitAggr) continue;
            rtAggrType = (node.getType() == 201017 || node.getType() == 201018) && iChild == 0 ? AggrTypeEnum.CALCULATED : AggrTypeEnum.SUMMARIZE;
        }
        return rtAggrType;
    }

    protected static AggrTypeEnum determineExpressionLeafAggregation(PlanningEnvironment environment, IXQEQueryNode node, IXQEQueryNode contextParentExprNode) {
        AggrTypeEnum rtAggrType = AggrTypeEnum.NONE;
        if (node.getType() == 601024) {
            Integer tp = ((RelationalOlapDecorationNode)node).getWrapType();
            if (tp != null && tp == 0) {
                rtAggrType = AggrTypeEnum.CALCULATED;
            }
            return rtAggrType;
        }
        if (node.getType() == 101003) {
            boolean bQueryRef = node.getPropertyValue("orgDefined") != null;
            return RefineAutomaticXtab.determineDataItemExpressionAggregation(environment, node, contextParentExprNode, bQueryRef);
        }
        if (!node.isOfCategory(201115)) {
            return AggrTypeEnum.NONE;
        }
        if (node.isOfCategory(201116)) {
            return RefineAutomaticXtab.determineModelDrivenAggregation(environment, (V5BoundModelIdentifier)node, contextParentExprNode);
        }
        int type = node.getType();
        switch (type) {
            case 201060: {
                V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
                V5DataItem v5DataItem = dataItemRef.getRefDataItem();
                rtAggrType = RefineAutomaticXtab.determineDataItemExpressionAggregation(environment, v5DataItem, contextParentExprNode, dataItemRef.isQueryRefItem());
                break;
            }
            case 201138: {
                rtAggrType = AggrTypeEnum.CALCULATED;
                break;
            }
            case 201097: {
                V5BoundQueryItemReference queryItemRef = (V5BoundQueryItemReference)node;
                V5DataItem v5DataItem = queryItemRef.getRefDataItem();
                if (v5DataItem == null || v5DataItem.getNumberChildren() != 1) break;
                String aggr = v5DataItem.getAggregateProperty();
                AggrTypeEnum aggrType = AggrTypeEnum.valueOfV5String(aggr);
                rtAggrType = RefineAutomaticXtab.determineAggrType(environment, v5DataItem.getChild(0), aggrType);
                break;
            }
        }
        return rtAggrType;
    }

    private static AggrTypeEnum determineDataItemExpressionAggregation(PlanningEnvironment environment, IXQEQueryNode node, IXQEQueryNode contextParentExprNode, boolean bQueryRef) {
        AggrTypeEnum rtAggrType = AggrTypeEnum.NONE;
        V5DataItem v5DataItem = (V5DataItem)node;
        if (v5DataItem.getNumberChildren() != 1) {
            return rtAggrType;
        }
        String aggr = v5DataItem.getAggregateProperty();
        AggrTypeEnum aggrType = AggrTypeEnum.valueOfV5String(aggr);
        rtAggrType = RefineAutomaticXtab.determineAggrType(environment, v5DataItem.getChild(0), aggrType);
        if (bQueryRef) {
            if (rtAggrType == AggrTypeEnum.CALCULATED) {
                rtAggrType = RefineAutomaticXtab.determineDatatypeDrivenAggregation(v5DataItem);
            }
            return rtAggrType;
        }
        if (rtAggrType != AggrTypeEnum.NONE) {
            rtAggrType = AggrTypeEnum.CALCULATED;
        }
        return rtAggrType;
    }

    public static AggrTypeEnum resolveSummarized(PlanningEnvironment environment, IXQEQueryNode node) {
        AggrTypeEnum rtAggrType = AggrTypeEnum.SUMMARIZE;
        if (node.getType() == 201116) {
            rtAggrType = RefineAutomaticXtab.determineModelDrivenAggregation(environment, (V5BoundModelIdentifier)node, null);
        }
        if (!rtAggrType.explicitAggr) {
            rtAggrType = RefineAutomaticXtab.determineDatatypeDrivenAggregation(node);
        }
        return rtAggrType;
    }

    public static AggrTypeEnum determineModelDrivenAggregation(PlanningEnvironment environment, V5BoundModelIdentifier node, IXQEQueryNode contextParentExprNode) {
        ICalculation calculation;
        AggrTypeEnum rtAggrType = AggrTypeEnum.NONE;
        if (node.isQueryItem()) {
            IQueryItem queryItem = (IQueryItem)node.getMetadata();
            if (queryItem.isFact()) {
                String aggr = queryItem.getRegularAggregate();
                AggrTypeEnum aggrType = AggrTypeEnum.valueOfModelString(aggr);
                if (aggrType == null) {
                    aggrType = AggrTypeEnum.valueOfV5String(aggr);
                }
                if (aggrType == null) {
                    aggrType = AggrTypeEnum.MIN;
                } else if (aggrType == AggrTypeEnum.AUTOMATIC) {
                    String itemExprStr = queryItem.getExpression();
                    if (itemExprStr != null && itemExprStr.length() > 0) {
                        IXQEQueryNode itemExpr = RQPUtilities.createV5ValueExpressionMetadata(itemExprStr, environment, node, queryItem);
                        itemExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, itemExpr);
                        aggrType = RefineAutomaticXtab.determineAggrType(environment, itemExpr, aggrType);
                        itemExpr.detach();
                    }
                } else if (aggrType == AggrTypeEnum.CALCULATED || aggrType == AggrTypeEnum.SUMMARIZE) {
                    aggrType = RefineAutomaticXtab.determineDatatypeDrivenAggregation(node);
                }
                if (aggrType == AggrTypeEnum.NONE || aggrType == AggrTypeEnum.AUTOMATIC) {
                    if ("unsupported".equals(aggr)) {
                        ResolveDataItemReferenceAutomaticAggregate.addNagIfFactItemIsUnsupported(environment, node);
                    }
                    rtAggrType = AggrTypeEnum.MIN;
                } else {
                    rtAggrType = aggrType;
                }
                if (!rtAggrType.explicitAggr) {
                    rtAggrType = contextParentExprNode != null ? AggrTypeEnum.CALCULATED : AggrTypeEnum.SUMMARIZE;
                }
            }
        } else if (node.isMeasure()) {
            String itemExprStr;
            IMeasure measure = (IMeasure)node.getMetadata();
            AggregateTypeEnum aggrTp = measure.getRegularAggregate();
            String aggr = aggrTp.getModelName();
            AggrTypeEnum aggrType = AggrTypeEnum.valueOfModelString(aggr);
            IAggregateRule[] rules = measure.getAggregateRules();
            if (aggrType == null || rules.length > 0) {
                aggrType = AggrTypeEnum.CALCULATED;
            } else if (aggrType == AggrTypeEnum.NONE) {
                aggrType = AggrTypeEnum.MIN;
            } else if (aggrType == AggrTypeEnum.AUTOMATIC && (itemExprStr = (String)measure.getProperty("expression")) != null && itemExprStr.length() > 0) {
                IXQEQueryNode itemExpr = RQPUtilities.createV5ValueExpressionMetadata(itemExprStr, environment, node, DMRUtilities.getWrapped(measure));
                itemExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, itemExpr);
                aggrType = RefineAutomaticXtab.determineAggrType(environment, itemExpr, aggrType);
                itemExpr.detach();
            }
            rtAggrType = aggrType == AggrTypeEnum.NONE || aggrType == AggrTypeEnum.AUTOMATIC ? AggrTypeEnum.SUMMARIZE : aggrType;
            if (!rtAggrType.explicitAggr) {
                rtAggrType = contextParentExprNode != null ? AggrTypeEnum.CALCULATED : AggrTypeEnum.SUMMARIZE;
            }
        } else if (node.isCalculation() && (calculation = (ICalculation)node.getMetadata()).isFact()) {
            rtAggrType = AggrTypeEnum.valueOfModelString(calculation.getRegularAggregate());
            if (rtAggrType == null || rtAggrType == AggrTypeEnum.NONE || rtAggrType == AggrTypeEnum.AUTOMATIC) {
                rtAggrType = AggrTypeEnum.CALCULATED;
            }
            if (!rtAggrType.explicitAggr) {
                rtAggrType = contextParentExprNode != null ? AggrTypeEnum.CALCULATED : AggrTypeEnum.SUMMARIZE;
            }
        }
        return rtAggrType;
    }

    public static IXQEQueryNode bindV5MultiPartIdentifierToModel(PlanningEnvironment environment, IXQEQueryNode node) {
        IXQEQueryNode[] identifiers;
        if (node.getType() == 201030) {
            V5BoundModelIdentifier boundNode = BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)node);
            if (boundNode != null) {
                return boundNode;
            }
            return node;
        }
        for (IXQEQueryNode identifier : identifiers = node.getDescendantsOfType(201030, false)) {
            BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)identifier);
        }
        return node;
    }

    protected static AggrTypeEnum determineDatatypeDrivenAggregation(IXQEQueryNode node) {
        AggrTypeEnum rt = AggrTypeEnum.COUNT;
        if (!node.isOfCategory(201120) && node.getType() != 101003) {
            return rt;
        }
        IDataType dt = null;
        dt = node.getType() == 101003 ? ((V5DataItem)node).getDataType() : ((V5SimpleNode)node).getDataType();
        if (dt == null) {
            return rt;
        }
        if (dt.isNumeric() || dt.isInterval()) {
            rt = AggrTypeEnum.TOTAL;
        } else if (dt.isDate() || dt.isTime() || dt.isTimestamp()) {
            rt = AggrTypeEnum.MAX;
        }
        return rt;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent;
        AggrTypeEnum rollUpType;
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        String aggr = v5DataItem.getAggregateProperty();
        String rollUp = v5DataItem.getRollupAggregateProperty();
        boolean status = false;
        AggrTypeEnum aggrType = AggrTypeEnum.valueOfV5String(aggr);
        if (aggrType != null && (rollUpType = AggrTypeEnum.valueOfV5String(rollUp)) != null && (rollUpType == AggrTypeEnum.AUTOMATIC || rollUpType == AggrTypeEnum.SUMMARIZE || aggrType == AggrTypeEnum.AUTOMATIC || aggrType == AggrTypeEnum.SUMMARIZE) && v5DataItem.getNumberChildren() == 1 && (parent = v5DataItem.getAncestorOfType(101009)) != null && (parent = parent.getParent()).getType() == 101006) {
            String queryName = ((V5Query)parent).getV5QueryName();
            if ((parent = parent.getParent()).getType() == 101002) {
                V5QueryResultDefinition v5QRD = null;
                IXQEQueryNode[] qrds = parent.getChildrenOfType(101055);
                if (qrds.length > 0) {
                    for (IXQEQueryNode qrdNode : qrds) {
                        V5QueryResultDefinition qrd = (V5QueryResultDefinition)qrdNode;
                        if (!queryName.equals(qrd.getRefQueryProperty())) continue;
                        v5QRD = (V5QueryResultDefinition)qrdNode;
                        break;
                    }
                } else {
                    IXQEQueryNode[] rsapis;
                    for (IXQEQueryNode aNode : rsapis = parent.getChildrenOfType(401005)) {
                        RSAPIDataset rsapiDataset = (RSAPIDataset)aNode;
                        if (!queryName.equals(rsapiDataset.getRefQueryName())) continue;
                        qrds = rsapiDataset.getDescendantsOfType(101055, false);
                        if (qrds.length != 1) break;
                        v5QRD = (V5QueryResultDefinition)qrds[0];
                        break;
                    }
                }
                if (v5QRD != null) {
                    boolean bl = status = !v5QRD.isList();
                }
            }
        }
        if (status) {
            this.traceNodeCondition(status, "need to refine automatic in XTab.", trace);
        } else {
            this.traceNodeCondition(status, "no automatic.", trace);
        }
        return status;
    }

    public static enum AggrTypeEnum {
        NONE(NONE_MODEL, NONE_V5, false),
        AUTOMATIC(AUTOMATIC_MODEL, AUTOMATIC_V5, false),
        SUMMARIZE(SUMMARIZE_MODEL, SUMMARIZE_V5, false),
        TOTAL(TOTAL_MODEL, TOTAL_V5, true),
        MIN(MIN_MODEL, MIN_V5, true),
        MAX(MAX_MODEL, MAX_V5, true),
        AVG(AVG_MODEL, AVG_V5, true),
        COUNT(COUNT_MODEL, COUNT_V5, true),
        CALCULATED(CALCULATED_MODEL, CALCULATED_V5, false),
        COUNTDISTINCT(COUNTDISTINCT_MODEL, COUNTDISTINCT_V5, true),
        STDDEV(STDDEV_MODEL, STDDEV_V5, true),
        VARIANCE(VARIANCE_V5, VARIANCE_V5, true),
        MEDIAN(MEDIAN_V5, MEDIAN_V5, true);

        private String[] modelAggregateString;
        private String[] v5StringType;
        private boolean explicitAggr = false;

        private AggrTypeEnum(String[] modelName, String[] theV5StringType, boolean aggr) {
            this.modelAggregateString = modelName;
            this.v5StringType = theV5StringType;
            this.explicitAggr = aggr;
        }

        public static AggrTypeEnum valueOfModelString(String name) {
            for (AggrTypeEnum e : AggrTypeEnum.values()) {
                for (String aName : e.modelAggregateString) {
                    if (!aName.equals(name)) continue;
                    return e;
                }
            }
            return null;
        }

        public static AggrTypeEnum valueOfV5String(String name) {
            for (AggrTypeEnum e : AggrTypeEnum.values()) {
                for (String aName : e.v5StringType) {
                    if (!aName.equals(name)) continue;
                    return e;
                }
            }
            return null;
        }

        public String getV5Name() {
            return this.v5StringType[0];
        }

        public boolean isExplicit() {
            return this.explicitAggr;
        }
    }
}

