/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5.RefineIfThenElseExpression;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RefineCaseExpression
extends Transformation {
    public static final String PROP_CASE_COULD_BE_COLLAPSED = "isCaseCouldBeCollapsed";
    public static final String PROP_COLLAPSED_CASE_EXPR = "isCollapsedCaseExpr";

    public RefineCaseExpression(int[] passNumbers) {
        this.mName = "Refine case-when expression";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201018};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int numOfChildren;
        IXQEQueryNode[] children = node.getChildren();
        boolean hasElse = children[(numOfChildren = children.length) - 1].getType() != 201019;
        IXQEQueryNode elseExpr = null;
        if (hasElse) {
            elseExpr = children[numOfChildren - 1];
        }
        boolean searchCase = children[0].getType() == 201019;
        IXQEQueryNode thenExpr = null;
        boolean allThenAndElseExprAreSame = true;
        RefineIfThenElseExpression.EvaluationTypeEnum evalType = null;
        boolean containsPromptInConditionClause = false;
        IXQEQueryNode[] prompts = null;
        for (IXQEQueryNode caseWhen : children) {
            if (caseWhen.getType() == 201019) {
                if (!containsPromptInConditionClause && (prompts = caseWhen.getChild(0).getDescendantsOfTypes(new int[]{201024, 201127}, true)).length > 0) {
                    containsPromptInConditionClause = true;
                }
                if (allThenAndElseExprAreSame) {
                    thenExpr = caseWhen.getChild(1);
                    if (elseExpr != null) {
                        allThenAndElseExprAreSame = RefineCaseExpression.isEqual(thenExpr, elseExpr);
                    } else {
                        boolean bl = allThenAndElseExprAreSame = thenExpr.getType() == 201023;
                    }
                }
            }
            if (!allThenAndElseExprAreSame) break;
        }
        if (allThenAndElseExprAreSame) {
            StringBuilder sb = new StringBuilder();
            node.writeFormattedText(sb);
            if (!searchCase && !containsPromptInConditionClause && (prompts = children[0].getDescendantsOfTypes(new int[]{201024, 201127}, true)).length > 0) {
                containsPromptInConditionClause = true;
            }
            if (!containsPromptInConditionClause) {
                thenExpr.setPropertyValue(PROP_COLLAPSED_CASE_EXPR, true);
                RefineCaseExpression.setQueryNotReusable(node);
                node.exchange(thenExpr, false);
                StringBuilder thenString = new StringBuilder();
                thenExpr.writeFormattedText(thenString);
                String nag = XQEMessages.getMessage(XQEMessageKeys.PLN_ExpressionIsCollapsedThenElseAreIdentical, XQEMessages.getCurrProductLocale(), sb.toString(), thenString.toString());
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
                return;
            }
            String nag = XQEMessages.getMessage(XQEMessageKeys.PLN_ExpressionIsNotCollapsedBecauseOfPromptInCondition, XQEMessages.getCurrProductLocale(), sb.toString());
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
        }
        IXQEQueryNode exprTrue = null;
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode caseWhen = children[i];
            if (caseWhen.getType() != 201019) {
                if (searchCase || i != 0) break;
                continue;
            }
            if (searchCase) {
                IXQEQueryNode comparisonNode = caseWhen.getChild(0);
                evalType = RefineIfThenElseExpression.evaluateBooleanExpression(comparisonNode, environment);
            } else {
                IXQEQueryNode leftExpr = children[0];
                IXQEQueryNode rightExpr = caseWhen.getChild(0);
                evalType = RefineIfThenElseExpression.evaluateConditionClauseForCollapsing(leftExpr, rightExpr, environment);
            }
            if (evalType == RefineIfThenElseExpression.EvaluationTypeEnum.TRUE) {
                exprTrue = caseWhen.getChild(1);
                break;
            }
            if (evalType != RefineIfThenElseExpression.EvaluationTypeEnum.FALSE) break;
        }
        if (exprTrue != null) {
            this.collapseToExpr(exprTrue, node, environment, evalType);
        } else if (evalType == RefineIfThenElseExpression.EvaluationTypeEnum.FALSE && elseExpr != null) {
            this.collapseToExpr(elseExpr, node, environment, evalType);
        } else {
            node.setPropertyValue(PROP_CASE_COULD_BE_COLLAPSED, evalType == RefineIfThenElseExpression.EvaluationTypeEnum.MISSING_PARAMETER_VALUE);
        }
    }

    public static boolean isEqual(IXQEQueryNode exp1, IXQEQueryNode exp2) {
        if (exp1.getType() == 201026 && exp2.getType() == 201026) {
            V5LiteralValue v1 = (V5LiteralValue)exp1;
            V5LiteralValue v2 = (V5LiteralValue)exp2;
            if (v1.getDataType().isTextType() && v2.getDataType().isTextType() && ((TextValue)v1.getValue()).getSQLLiteral().length() != ((TextValue)v2.getValue()).getSQLLiteral().length()) {
                return false;
            }
        }
        return exp1.isSameExpression(exp2, false);
    }

    protected void collapseToExpr(IXQEQueryNode expr, IXQEQueryNode node, PlanningEnvironment environment, RefineIfThenElseExpression.EvaluationTypeEnum evalType) {
        expr.setPropertyValue(PROP_COLLAPSED_CASE_EXPR, true);
        RefineCaseExpression.setQueryNotReusable(node);
        if (expr.getType() == 201023 && node.getParent().getType() != 201013) {
            IDataType dataType = ((V5CaseExpression)node).getDataType();
            if (dataType != null && dataType.getCCLTypeCode() != 22) {
                if (!RQPUtilities.exprInOLAPContext(expr)) {
                    expr = RQPUtilities.buildCastNode(environment, expr, dataType);
                }
            } else {
                expr.setPropertyValue(PROP_COLLAPSED_CASE_EXPR, false);
                node.setPropertyValue(PROP_CASE_COULD_BE_COLLAPSED, evalType == RefineIfThenElseExpression.EvaluationTypeEnum.MISSING_PARAMETER_VALUE);
                return;
            }
        }
        node.exchange(expr, false);
    }

    public static void setQueryNotReusable(IXQEQueryNode node) {
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (v5QuerySet != null) {
            v5QuerySet.setNonReusable(true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return node.getPropertyValue(PROP_CASE_COULD_BE_COLLAPSED) == null;
    }
}

