/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;

public class RefineSummarize
extends Transformation {
    public RefineSummarize() {
        this.mName = "Refine dataItem rollupAggregation summarize settings";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String rollupAggregate = this.resolveSummarizeRollupAggregateForOlap(node);
        V5DataItem v5DataItem = (V5DataItem)node;
        v5DataItem.setRollupAggregateProperty(rollupAggregate);
    }

    private String resolveSummarizeRollupAggregateForOlap(IXQEQueryNode node) {
        IXQEQueryNode expression = node.getChild(0);
        while (!expression.isOfCategory(201120)) {
            expression = expression.getChild(0);
        }
        if (expression.getType() == 201113 && expression.getNumberChildren() == 1 && expression.getChild(0).isOfCategory(201123) && expression.getChild(0).getNumberChildren() == 1) {
            expression = expression.getChild(0).getChild(0);
        }
        if (this.isReferenceToSingleModeledMeasure(expression)) {
            return this.aggregateAccordingToRegularAggregateOfMeasureOrCalculated(expression);
        }
        return this.aggregateAccordingToDataType(expression);
    }

    private boolean isReferenceToSingleModeledMeasure(IXQEQueryNode expression) {
        V5BoundModelIdentifier identifier;
        return expression.getType() == 201116 && (identifier = (V5BoundModelIdentifier)expression).isMeasure();
    }

    private String aggregateAccordingToRegularAggregateOfMeasureOrCalculated(IXQEQueryNode identifier) {
        String regularAggregateName = ((V5BoundModelIdentifier)identifier).getRegularAggregate();
        if (regularAggregateName != null && !regularAggregateName.equals("unknown")) {
            if (regularAggregateName.equals("sum")) {
                return "total";
            }
            if (regularAggregateName.equals("unsupported")) {
                return "none";
            }
            return regularAggregateName;
        }
        return "calculated";
    }

    private String aggregateAccordingToDataType(IXQEQueryNode expression) {
        IDataType dataType = ((V5SimpleNode)expression).getDataType();
        return RQPUtilities.getDefaultAggregateNameBasedOnDataType(dataType);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean flagScalarFunctionXTab;
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        V5Query query = (V5Query)v5DataItem.getAncestorOfType(101006);
        if (query == null) {
            this.traceNodeCondition(false, "DataItem not hooked under a valid query.", trace);
            return false;
        }
        Boolean property = query.getV5Source().needQueryOverTabularStream();
        boolean bl = flagScalarFunctionXTab = property != null && property != false;
        if (!(query.isTabular() || query.isRelStyle() || flagScalarFunctionXTab)) {
            String rollupAggregateFunc = v5DataItem.getRollupAggregateProperty();
            if (rollupAggregateFunc == null || rollupAggregateFunc.compareTo("summarize") != 0) {
                this.traceNodeCondition(false, "This 'rollupAggregate' property value is not summarize.", trace);
                return false;
            }
            return true;
        }
        return false;
    }
}

