/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveQRDsOnInvalidRetrieveDataset
extends Transformation {
    public RemoveQRDsOnInvalidRetrieveDataset(int passNumber) {
        this.mName = "Remove QRDs on invalid retrieveDataset";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean passesNodeCondition;
        XQETrace trace = environment.getTrace();
        V5QuerySet v5QuerySet = (V5QuerySet)node;
        String[] queryResultDefinitionNames = v5QuerySet.getRetrieveDatasetArray();
        if (queryResultDefinitionNames == null) {
            this.traceQueryCondition(false, "No retrieveDataset is present.", trace);
            return false;
        }
        if (queryResultDefinitionNames.length > 0) {
            if (!v5QuerySet.hasNoQRDs()) {
                boolean allRetrieveDatasetAreInvalid = true;
                for (String qrdName : queryResultDefinitionNames) {
                    if (null == v5QuerySet.getQRD(qrdName)) continue;
                    allRetrieveDatasetAreInvalid = false;
                    break;
                }
                if (allRetrieveDatasetAreInvalid) {
                    passesNodeCondition = true;
                    this.traceQueryCondition(passesNodeCondition, "All retrieveDataset are invalid.", trace);
                } else {
                    passesNodeCondition = false;
                    this.traceQueryCondition(passesNodeCondition, "At least one retrieveDataset is valid.", trace);
                }
            } else {
                passesNodeCondition = false;
                this.traceQueryCondition(passesNodeCondition, "No QRD.", trace);
            }
        } else {
            passesNodeCondition = false;
            this.traceQueryCondition(passesNodeCondition, "No retrieveDataset element is present.", trace);
        }
        if (passesNodeCondition) {
            XQEDebugLog.err.println("INVALID retrieveDataset (RemoveQRDsOnInvalidRetrieveDataset)");
        }
        return passesNodeCondition;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        for (IXQEQueryNode child : node.getChildrenOfType(101055)) {
            child.detach();
        }
    }
}

