/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashMap;
import java.util.Set;

public class RemoveV5DataItemCreatedForModelCalculation
extends Transformation {
    public RemoveV5DataItemCreatedForModelCalculation() {
        this.mName = "RemoveV5DataItemCreatedForModelCalculation.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        HashMap calculationToV5DataItems = (HashMap)node.getPropertyValue("calculationToDataItems");
        Set calculations = calculationToV5DataItems.keySet();
        for (IMetadata calc : calculations) {
            V5DataItem v5Di = (V5DataItem)calculationToV5DataItems.get(calc);
            if (v5Di.getPropertyValue("copyOnlyCalculationExpression") == null) continue;
            v5Di.extract();
        }
        node.removeProperty("calculationToDataItems");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        HashMap calculationToV5DataItems = (HashMap)node.getPropertyValue("calculationToDataItems");
        if (calculationToV5DataItems == null) {
            this.traceQueryCondition(false, "There are no model calculations in the query.", trace);
            return false;
        }
        Set calculations = calculationToV5DataItems.keySet();
        for (IMetadata calc : calculations) {
            V5DataItem v5Di = (V5DataItem)calculationToV5DataItems.get(calc);
            if (v5Di.getPropertyValue("copyOnlyCalculationExpression") == null) continue;
            return true;
        }
        this.traceQueryCondition(false, "There are no V5DataItem nodes to be removed.", trace);
        return false;
    }
}

