/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ReplaceV5HierarchyWithV5BoundMultiPartIdentifier
extends Transformation {
    public static final String PROP_COLLAPSED_HIERARCHY_FUNC = "isCollapsedHierarchyFunction";

    public ReplaceV5HierarchyWithV5BoundMultiPartIdentifier() {
        this.mName = "Replace V5Hierarchy with V5BoundMultiPartIdentifier.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{201073};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXHierInfo hierInfo = ((V5SimpleNode)node).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        newNode.setMetadata(hierarchy);
        newNode.setIdentifier(hierarchy.getV5UniqueName());
        newNode.setPropertyValue(PROP_COLLAPSED_HIERARCHY_FUNC, Boolean.TRUE);
        node.getParent().exchangeChildNode(node, newNode, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(101006) == null) {
            this.traceQueryCondition(false, "The V5 expression is not within a V5Query.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((V5SimpleNode)node).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The projected hierarchy cannot be determined for the first child of the target V5HierarchyFunction node.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5 hierarchy function can be replaced with a hierarchy.", trace);
        return true;
    }
}

