/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;

public class SetMasterDetailLinkRelationships
extends Transformation {
    public SetMasterDetailLinkRelationships() {
        this.mName = "Set relationships between master-detail links.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101059};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query masterQuery;
        V5Query detailQuery;
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        MasterDetailLink link = linkNode.getMDProviderLink();
        String replanQuery = ((RequestEnvironment)environment.getRequestEnvironment()).getReplanQuery();
        if (replanQuery != null && !link.getDetailQrdName().equals(replanQuery)) {
            node.detach();
            return;
        }
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        mdProvider.setParentMDLink(link);
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet == null) {
            node.throwInternalError("The master detail link node should be in a querySet");
        }
        if ((detailQuery = querySet.getV5Query(link.getDetailQueryName())) == null) {
            node.throwInternalError("The detail QRD should be in a querySet");
        }
        if ((masterQuery = querySet.getV5Query(link.getMasterQueryName())) == null) {
            node.throwInternalError("The master QRD should be in a querySet");
        }
        HashSet<String> detailQueryRefs = new HashSet<String>();
        detailQuery.getAllSubQueryNames(detailQueryRefs, querySet, environment);
        if (!detailQueryRefs.isEmpty()) {
            link.setDetailQueryRefNames(detailQueryRefs);
        }
        HashSet<String> masterQueryRefs = new HashSet<String>();
        masterQuery.getAllSubQueryNames(masterQueryRefs, querySet, environment);
        if (!masterQueryRefs.isEmpty()) {
            link.setMasterQueryRefNames(masterQueryRefs);
        }
        linkNode.setPropertyValue("linkProcessed", true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        boolean bl = status = node.getBooleanPropertyValue("linkProcessed") == null;
        if (!status) {
            this.traceQueryCondition(false, "The master-detail link relationships are already set for this link.", trace);
            return false;
        }
        MasterDetailLink link = linkNode.getMDProviderLink();
        if (link == null) {
            node.throwInternalError("The link item should have been created by ProcessMasterDetailLinks");
        }
        this.traceQueryCondition(true, "Set master-detail link relationships for this link.", trace);
        return status;
    }
}

