/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemOfDimension;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5.unwinding.UnwindV5BoundModelId;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ConvertSecurityFiltersForQSToDetail;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class AddEmbeddedFiltersOfDimensionToV5Query
extends Transformation {
    public AddEmbeddedFiltersOfDimensionToV5Query() {
        this.mName = "Add embedded filters of dimension to V5Query.";
        this.mPassNumbers = new int[]{29};
        this.mTypes = new int[]{201116, 201117};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IDimension targetDim;
        V5BoundToMetadata v5BoundModelID = (V5BoundToMetadata)node;
        IMetadata metadata = v5BoundModelID.getMetadata();
        IDimension dimension = MetadataUtil.getDimension(metadata);
        if (dimension.isMeasuresDimension() && (targetDim = MetadataUtil.getTargetDim(dimension)) != dimension && targetDim.getObjectType() == MetadataType.DIMENSION) {
            dimension = targetDim;
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        AddEmbeddedFiltersOfDimensionToV5Query.createV5DetailFiltersForEmbeddedOrPreview(dimension, dimension.getFilters(), v5Query, node, environment);
        if (node.getGovernors().getDesignMode().booleanValue()) {
            AddEmbeddedFiltersOfDimensionToV5Query.createV5DetailFiltersForEmbeddedOrPreview(dimension, dimension.getPreviewFilters(), v5Query, node, environment);
        }
        AddEmbeddedFiltersOfDimensionToV5Query.createV5DetailFilterForSecurityFilters(dimension, dimension.getSecurityFilters(), v5Query, node, environment);
        if (this.isRootMemberInDetailFilterSlicer(node)) {
            this.setMandatoryOnExistingFilters(node);
        }
    }

    public static void createV5DetailFiltersForEmbeddedOrPreview(IMetadata metadata, List<IEmbeddedFilter> filters, V5Query v5Query, IXQEQueryNode node, PlanningEnvironment environment) {
        for (IEmbeddedFilter filter : filters) {
            V5DetailFilter detailFilter = (V5DetailFilter)environment.getNodeFactory().createNode(101008);
            if (!node.getGovernors().getDesignMode().booleanValue() && filter.getApplyAttribute() == "asNeeded") {
                detailFilter.setUseProperty("optional");
            }
            v5Query.addChild(detailFilter);
            IXQEQueryNode v5ValueExpression = RQPUtilities.createV5ExpressionFromFilter(environment, filter, null, detailFilter);
            if (v5ValueExpression == null) {
                detailFilter.extract();
                continue;
            }
            IXQEQueryNode filterExpression = environment.getNodeFactory().createNode(101013);
            filterExpression.setPropertyValue("expression", filter.getExpression());
            filterExpression.addChild(v5ValueExpression);
            detailFilter.setFilterOwner(metadata);
            V5DetailFilter ancestorDetailFilter = (V5DetailFilter)node.getAncestorOfType(101008);
            if (ancestorDetailFilter != null) {
                IMetadata introducingFilterOwner = ancestorDetailFilter.getIntroducingFilterOwner();
                if (introducingFilterOwner == null) {
                    introducingFilterOwner = ancestorDetailFilter.getFilterOwner();
                }
                detailFilter.setIntroducingFilterOwner(introducingFilterOwner);
            }
            detailFilter.setOriginalExpression(filter.getExpression());
            detailFilter.addChild(filterExpression);
        }
    }

    public static void createV5DetailFilterForSecurityFilters(IMetadata metadata, List<IEmbeddedFilter> filters, V5Query v5Query, IXQEQueryNode boundModelID, PlanningEnvironment environment) {
        if (filters.size() > 0) {
            RMEmbeddedFilterList embeddedFilterList = (RMEmbeddedFilterList)environment.getNodeFactory().createNode(801036);
            RMEmbeddedFilterList.createRMEmbeddedFiltersForSecurity(environment, filters, embeddedFilterList);
            int[] pn = new int[]{1};
            ConvertSecurityFiltersForQSToDetail transformation = new ConvertSecurityFiltersForQSToDetail(pn);
            ((Transformation)transformation).apply((IXQEQueryNode)embeddedFilterList, environment);
            if (embeddedFilterList.getChildren().length > 0) {
                IXQEQueryNode[] sqlLogicalNodes;
                for (IXQEQueryNode node : sqlLogicalNodes = embeddedFilterList.getDescendantsOfType(301027, false)) {
                    SQLLogical sqlLogical = (SQLLogical)node;
                    V5LogicalExpression v5Logical = (V5LogicalExpression)environment.getNodeFactory().createNode(201003);
                    if (sqlLogical.getSubType() == SQLLogical.SubType.AND) {
                        v5Logical.setSubType(0);
                    } else if (sqlLogical.getSubType() == SQLLogical.SubType.OR) {
                        v5Logical.setSubType(1);
                    } else if (sqlLogical.getSubType() == SQLLogical.SubType.NOT) {
                        v5Logical.setSubType(2);
                    }
                    sqlLogical.exchange(v5Logical, true);
                }
                IXQEQueryNode v5ValueExpression = embeddedFilterList.getChild(0).getChild(0);
                if (v5ValueExpression != null) {
                    V5DetailFilter detailFilter = (V5DetailFilter)environment.getNodeFactory().createNode(101008);
                    detailFilter.setFilterOwner(metadata);
                    V5DetailFilter ancestorDetailFilter = (V5DetailFilter)boundModelID.getAncestorOfType(101008);
                    if (ancestorDetailFilter != null) {
                        IMetadata introducingFilterOwner = ancestorDetailFilter.getIntroducingFilterOwner();
                        if (introducingFilterOwner == null) {
                            introducingFilterOwner = ancestorDetailFilter.getFilterOwner();
                        }
                        detailFilter.setIntroducingFilterOwner(introducingFilterOwner);
                    }
                    v5Query.addChild(detailFilter);
                    IXQEQueryNode filterExpression = environment.getNodeFactory().createNode(101013);
                    detailFilter.addChild(filterExpression);
                    v5ValueExpression.move(filterExpression);
                }
            }
            embeddedFilterList.removeFromIndex();
        }
    }

    private boolean canFiltersBeAddedToV5Query(PlanningEnvironment environment, IDimension dimension, IXQEQueryNode node) {
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        if (UnwindV5BoundModelId.filtersAlreadyAddedToV5Query(v5Query, dimension)) {
            return false;
        }
        List<IEmbeddedFilter> embeddedFilters = dimension.getFilters();
        int numberOfEmbeddedFilters = 0;
        if (embeddedFilters != null) {
            for (IEmbeddedFilter filter : embeddedFilters) {
                IXQEQueryNode v5ValueExpression = RQPUtilities.createV5ExpressionFromFilter(environment, filter);
                if (v5ValueExpression == null) continue;
                ++numberOfEmbeddedFilters;
            }
        }
        List<IEmbeddedFilter> previewFilters = null;
        if (node.getGovernors().getDesignMode().booleanValue()) {
            previewFilters = dimension.getPreviewFilters();
        }
        List<IEmbeddedFilter> securityFilters = dimension.getSecurityFilters();
        return embeddedFilters != null && numberOfEmbeddedFilters != 0 || previewFilters != null && previewFilters.size() != 0 || securityFilters != null && securityFilters.size() != 0;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IMetadata target;
        V5Query v5Query;
        Object subQueryFlag;
        boolean bInSelection;
        V5Selection selection = (V5Selection)node.getAncestorOfType(101009);
        boolean bl = bInSelection = selection != null;
        if (!bInSelection && (subQueryFlag = (v5Query = (V5Query)node.getAncestorOfType(101006)).getPropertyValue("relationalSubquery")) == null) {
            bInSelection = this.isRootMemberInDetailFilterSlicer(node);
        }
        if (!bInSelection) {
            this.traceQueryCondition(false, "V5BoundModelIdentifier node is not within a V5Selection.", environment.getTrace());
            return false;
        }
        V5BoundToMetadata v5BoundModelID = (V5BoundToMetadata)node;
        IMetadata metadata = v5BoundModelID.getMetadata();
        if (!(metadata instanceof IQueryItemOfLevel || metadata instanceof ILevel || metadata instanceof IHierarchy || metadata instanceof IMeasure || metadata instanceof IQueryItemOfDimension)) {
            this.traceQueryCondition(false, "V5BoundModelIdentifier node is not a level, a query item of a level, an hierarchy, a measure, or query item of a dimension", environment.getTrace());
            return false;
        }
        IDimension dimension = MetadataUtil.getDimension(metadata);
        if (dimension == null) {
            this.traceQueryCondition(false, "Dimension is null.", environment.getTrace());
            return false;
        }
        if (dimension.isMeasuresDimension() && dimension.isAccessedViaShortcut() && (target = dimension.getShortcut().getTarget()).getObjectType() == MetadataType.DIMENSION) {
            dimension = (IDimension)target;
        }
        if (!this.canFiltersBeAddedToV5Query(environment, dimension, node)) {
            if (this.isRootMemberInDetailFilterSlicer(node)) {
                this.setMandatoryOnExistingFilters(node);
            }
            this.traceQueryCondition(false, "Dimension has no embedded filters or filters are already added in the V5Query.", environment.getTrace());
            return false;
        }
        return true;
    }

    private boolean isRootMemberInDetailFilterSlicer(IXQEQueryNode node) {
        IXQEQueryNode[] children;
        if (node.getType() != 201117) {
            return false;
        }
        V5BoundToMetadata v5BoundModelID = (V5BoundToMetadata)node;
        IMetadata metadata = v5BoundModelID.getMetadata();
        IDimension dimension = MetadataUtil.getDimension(metadata);
        if (dimension == null || dimension.isMeasuresDimension()) {
            return false;
        }
        int[] types = new int[]{101008, 101014, 101010};
        if (node.getAncestorOfTypes(types) != null) {
            return true;
        }
        IXQEQueryNode di = node.getAncestorOfType(101003);
        if (di == null) {
            return false;
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        for (IXQEQueryNode c : children = v5Query.getChildrenOfTypes(types)) {
            IXQEQueryNode[] refs;
            for (IXQEQueryNode ref : refs = c.getDescendantsOfType(201060, false)) {
                V5BoundDataItemReference diRef = (V5BoundDataItemReference)ref;
                if (diRef.isQueryRefItem() || di != diRef.getRefDataItem()) continue;
                return true;
            }
        }
        return false;
    }

    private void setMandatoryOnExistingFilters(IXQEQueryNode node) {
        IXQEQueryNode[] v5DetailFilters;
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        V5BoundToMetadata v5BoundModelID = (V5BoundToMetadata)node;
        IMetadata metadata = v5BoundModelID.getMetadata();
        IDimension dimension = MetadataUtil.getDimension(metadata);
        for (IXQEQueryNode df : v5DetailFilters = v5Query.getDescendantsOfType(101008, false)) {
            V5DetailFilter v5DetailFilter = (V5DetailFilter)df;
            if (v5DetailFilter.getFilterOwner() == null || dimension.compareTo(v5DetailFilter.getFilterOwner()) != 0) continue;
            v5DetailFilter.setPropertyValue("DMRMandatoryEmbeddedFilter", Boolean.TRUE);
        }
    }
}

