/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;

public class DecomposeRelativeTimeCalculation
extends Transformation {
    public static final String RELATIVE_TIME_CALCULATION = "RTCalc";
    protected static final String APPLIED = "DecomposeRT";

    public DecomposeRelativeTimeCalculation() {
        this.mName = "Decompose Relative Time Calculation";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{201018};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        IXQEQueryNode thenExpr = node.getChild(0).getChild(1);
        thenExpr.detach();
        node.detach();
        node.setPropertyValue(APPLIED, Boolean.TRUE);
        this.decomposeExpression(environment, thenExpr.getChild(0), false, node, 1, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
        parent.addChild(thenExpr.getChild(0));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (this.checkCondition(node, environment)) {
            this.traceQueryCondition(true, "Need to decompose.", trace);
            return true;
        }
        this.traceQueryCondition(false, "no Need to decompose.", trace);
        return false;
    }

    protected boolean checkCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b = (Boolean)node.getPropertyValue(APPLIED);
        if (Boolean.TRUE.equals(b)) {
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getType() != 101003) {
            return false;
        }
        V5DataItem dataItem = (V5DataItem)parent;
        String aggr = dataItem.getAggregateProperty();
        if (!"calculated".equals(aggr)) {
            return false;
        }
        if (!dataItem.isModuleCalculation()) {
            return false;
        }
        b = (Boolean)dataItem.getPropertyValue(RELATIVE_TIME_CALCULATION);
        if (!Boolean.TRUE.equals(b)) {
            return false;
        }
        IXQEQueryNode thenExpr = node.getChild(0).getChild(1);
        if (thenExpr.getType() != 101003) {
            return false;
        }
        dataItem = (V5DataItem)thenExpr;
        return TabStreamUtil.needDecompose(environment, dataItem);
    }

    protected boolean decomposeExpression(PlanningEnvironment env, IXQEQueryNode expr, boolean bDecompose, IXQEQueryNode topNode, int sepRules, RefineAutomaticXtab.AggrTypeEnum defaultAggr) {
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        if (!TabStreamUtil.useMetadataObjects(expr, true)) {
            return false;
        }
        boolean bDecompPoint = false;
        if (expr.isOfCategory(201120)) {
            V5SimpleNode simpleNode = (V5SimpleNode)expr;
            bDecompPoint = TabStreamUtil.checkDecomposePoint(simpleNode, sepRules);
        }
        if (bDecompPoint) {
            if (!TabStreamUtil.needDecomposeExpression(env, expr, false, sepRules, defaultAggr)) {
                return false;
            }
            if ((sepRules & 1) != 1) {
                sepRules |= 1;
            }
            IXQEQueryNode[] children = expr.getChildren();
            for (int cPos = 0; cPos < children.length; ++cPos) {
                int sepRulesChild = sepRules;
                if (expr.getType() == 201017 && cPos == 0 && (sepRulesChild & 4) != 4) {
                    sepRulesChild |= 4;
                }
                this.decomposeExpression(env, children[cPos], true, topNode, sepRulesChild, defaultAggr);
            }
            return true;
        }
        if (bDecompose) {
            if (expr.getType() == 101003) {
                boolean bNeedDecomp = false;
                bNeedDecomp = (sepRules & 2) != 2 ? TabStreamUtil.needDecompose(env, (V5DataItem)expr) : TabStreamUtil.needDecomposeExpression(env, expr.getChild(0), false, sepRules, defaultAggr);
                if (bNeedDecomp) {
                    return this.decomposeExpression(env, expr.getChild(0), bDecompose, topNode, sepRules, defaultAggr);
                }
            }
            this.wrapExpr(env, expr, topNode);
            return true;
        }
        return false;
    }

    protected void wrapExpr(PlanningEnvironment env, IXQEQueryNode expr, IXQEQueryNode topNode) {
        XQENodeFactory factory = env.getNodeFactory();
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        dataItem.setNameProperty("_dummyRT_DI_" + expr.getId());
        RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(env, expr, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
        dataItem.setAggregateProperty(aggrType.getV5Name());
        IXQEQueryNode newNode = factory.deepCopyNode(topNode);
        dataItem.addChild(newNode);
        expr.exchange(dataItem);
        newNode.getChild(0).addChild(expr, 1);
    }
}

