/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.util.LoopDetectionChain;
import java.util.LinkedHashSet;

public class IdentifyGroupedProperties
extends Transformation {
    public static final String PROP_BOOLEAN_IS_GROUPED_PROPERTY = "isGroupedProperty";
    private static final int[] OLAP_NODE_CATEGORIES = new int[]{201121, 201122, 201123};
    private static final int[] OLAP_NODE_TYPES = new int[]{201039, 201050, 201073, 201034, 201032, 201092, 201098};

    public IdentifyGroupedProperties() {
        this.mName = "Identify data items value expressions based on properties projected in valuesets which are grouping the result.";
        this.mPassNumbers = new int[]{32};
        this.mTypes = new int[]{101057};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getBooleanPropertyValue(PROP_BOOLEAN_IS_GROUPED_PROPERTY) != null) {
            this.traceNodeCondition(false, "Already processed this valueset.", trace);
            return false;
        }
        if (!IdentifyGroupedProperties.isGroupingOlapValuesConfigurationEnabled(environment)) {
            this.traceNodeCondition(false, "Grouping on OLAP properties is not enabled.", trace);
            return false;
        }
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItemName = valueSet.getRefDataItemProperty();
        if (refDataItemName != null && refDataItemName.length() > 0) {
            if (valueSet.hasChildOfType(101051)) {
                this.traceNodeCondition(false, "Non-detail group body, skip grouping for these cases.", trace);
                return false;
            }
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
            V5Query query = qrd.getV5Query();
            V5Selection selection = query.getV5Selection();
            V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName);
            if (dataItem != null && V5ExpressionCheck.isValueExpression(dataItem)) {
                IXQEQueryNode expression = dataItem.getChild(0);
                IQueryItem propertyMetadata = IdentifyGroupedProperties.getPropertyMetadata(expression);
                if (propertyMetadata == null || !propertyMetadata.isDMR()) {
                    this.traceNodeCondition(false, "A non-property metadata reference was found in the data item expression.", trace);
                    return false;
                }
                this.traceNodeCondition(true, "The grouped data item has a value expression based on property values.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "No grouping expression found.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItemName = valueSet.getRefDataItemProperty();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5Query query = qrd.getV5Query();
        V5Selection selection = query.getV5Selection();
        V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName);
        IDataType dt = dataItem.getDataType();
        if (dt != null) {
            node.setPropertyValue(PROP_BOOLEAN_IS_GROUPED_PROPERTY, Boolean.TRUE);
        } else {
            IXQEQueryNode[] props;
            for (IXQEQueryNode prop : props = dataItem.getDescendantsOfType(201116, false)) {
                MixedDMRRelUtil.unwindLevelPropertyToRelational(environment, prop);
            }
        }
    }

    private static boolean isGroupingOlapValuesConfigurationEnabled(PlanningEnvironment environment) {
        return environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.groupingOlapValues[@enabled]", true);
    }

    public static IQueryItem getPropertyMetadata(IXQEQueryNode expression) {
        LinkedHashSet<IMetadata> usedMeta = new LinkedHashSet<IMetadata>();
        LoopDetectionChain ldc = new LoopDetectionChain();
        boolean[] rtFlag = new boolean[]{false};
        IdentifyGroupedProperties.getUsedMetadataObjects(expression, usedMeta, ldc, rtFlag);
        if (rtFlag[0]) {
            return null;
        }
        IQueryItem rt = null;
        for (IMetadata metaData : usedMeta) {
            if (metaData.getObjectType() != MetadataType.QUERY_ITEM) {
                return null;
            }
            IQueryItem queryItem = (IQueryItem)metaData;
            if (!queryItem.isProperty()) {
                return null;
            }
            if (rt != null) continue;
            rt = queryItem;
        }
        return rt;
    }

    private static void getUsedMetadataObjects(IXQEQueryNode node, LinkedHashSet<IMetadata> usedMeta, LoopDetectionChain ldc, boolean[] rtFlag) {
        IXQEQueryNode expression = node;
        if (expression.getType() == 201060) {
            V5DataItem refDataItem = ((V5BoundDataItemReference)expression).getRefDataItem();
            if (!ldc.push(refDataItem.getFullName())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInQuery, ldc.serialize());
            }
            expression = refDataItem.getChild(0);
            IdentifyGroupedProperties.getUsedMetadataObjects(expression, usedMeta, ldc, rtFlag);
            ldc.pop();
            return;
        }
        if (expression.isOfCategory(201029)) {
            IMetadata obj = ((V5BoundToMetadata)expression).getMetadata();
            if (obj != null) {
                usedMeta.add(obj);
            }
            return;
        }
        if (expression.isOfCategories(OLAP_NODE_CATEGORIES) || expression.isOfTypes(OLAP_NODE_TYPES)) {
            rtFlag[0] = true;
            return;
        }
        for (IXQEQueryNode c : expression.getChildren()) {
            IdentifyGroupedProperties.getUsedMetadataObjects(c, usedMeta, ldc, rtFlag);
            if (rtFlag[0]) break;
        }
    }
}

