/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.AbstractV5Tuple;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5IfExpression;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.binding.BindIdentifierNotFoundException;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;

public final class SetDataItemDetailProperty
extends Transformation {
    private static int[] summaryTypes = new int[]{201034, 201032};

    public SetDataItemDetailProperty() {
        this.mName = "Set dataItem 'detail' property value.";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{101003};
    }

    private String resolveDetailProperty(V5DataItem v5DataItem, PlanningEnvironment environment) {
        IXQEQueryNode definition = v5DataItem.getChild(0);
        if (definition.getType() == 101004 && definition.getNumberChildren() > 0) {
            definition = definition.getChild(0);
        }
        V5Selection v5Selection = (V5Selection)v5DataItem.getAncestorOfType(101009);
        return SetDataItemDetailProperty.resolveDetailForV5Expression(definition, v5Selection);
    }

    public static String resolveDetailForV5Expression(IXQEQueryNode v5Expression, V5Selection v5Selection) {
        String detail = "automatic_true";
        detail = v5Expression.isOfCategory(201122) ? SetDataItemDetailProperty.resolveDetailPropertyForAbstractV5Set((AbstractV5Set)v5Expression, v5Selection) : SetDataItemDetailProperty.genericResolveDetailProperty(v5Expression, v5Selection);
        return detail;
    }

    private static String resolveDetailPropertyForIfExpression(V5IfExpression v5IfExpression, V5Selection v5Selection) {
        IXQEQueryNode[] children;
        String detail = "automatic_true";
        for (IXQEQueryNode currChild : children = new IXQEQueryNode[]{v5IfExpression.getChild(1), v5IfExpression.getChild(2)}) {
            detail = SetDataItemDetailProperty.genericResolveDetailProperty(currChild, v5Selection);
            if (!detail.equals("automatic_false") && !detail.equals("false")) continue;
            return detail;
        }
        return detail;
    }

    private static Object resolveDetailPropertyForV5MultiPartIdentifier(V5MultiPartIdentifier v5MultiPartIdentifier, V5Selection v5Selection) {
        String detail;
        block4: {
            detail = null;
            String identifier = v5MultiPartIdentifier.getIdentifier();
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(identifier, -1);
                if (parts.length != 1) break block4;
                V5DataItem refV5DataItem = v5Selection.getDataItemByRefName(parts[0]);
                if (refV5DataItem != null) {
                    detail = refV5DataItem.getDetailProperty();
                    break block4;
                }
                throw new BindIdentifierNotFoundException(identifier);
            }
            catch (UniqueNameParserException uniqueNameParserException) {
                // empty catch block
            }
        }
        if (detail == null) {
            detail = "automatic_true";
        }
        return detail;
    }

    private static String resolveDetailPropertyForAbstractV5Set(AbstractV5Set abstractV5Set, V5Selection v5Selection) {
        String detail = null;
        IXQEQueryNode[] children = abstractV5Set.getChildren();
        for (int childPos = 0; childPos < children.length; ++childPos) {
            String currDetail = "automatic_true";
            if (!abstractV5Set.isChildAtIndexProjected(childPos)) continue;
            IXQEQueryNode currChild = children[childPos];
            if (currChild.isOfCategory(201122)) {
                currDetail = SetDataItemDetailProperty.resolveDetailPropertyForAbstractV5Set((AbstractV5Set)currChild, v5Selection);
            } else if (currChild.getType() == 201085) {
                currDetail = SetDataItemDetailProperty.resolveDetailPropertyForMemberFnc((V5MemberFunction)currChild, v5Selection);
            } else if (currChild.isOfCategory(201123)) {
                currDetail = SetDataItemDetailProperty.resolveDetailPropertyForAbstractV5tuple((AbstractV5Tuple)currChild, v5Selection);
            } else if (currChild.getType() == 201030) {
                Object v5MultiPartIdDetail = SetDataItemDetailProperty.resolveDetailPropertyForV5MultiPartIdentifier((V5MultiPartIdentifier)currChild, v5Selection);
                if (v5MultiPartIdDetail.equals("automatic")) {
                    return "automatic";
                }
                currDetail = (String)v5MultiPartIdDetail;
            } else if (currChild.isOfCategory(201060) && (currDetail = SetDataItemDetailProperty.resolveDetailPropertyForBoundDataItemReference(currChild)).equals("automatic")) {
                return "automatic";
            }
            if (detail != null && !detail.equals(currDetail)) {
                return "automatic_true";
            }
            detail = currDetail;
        }
        if (detail == null) {
            detail = "automatic_true";
        }
        return detail;
    }

    private static String resolveDetailPropertyForAbstractV5tuple(AbstractV5Tuple abstractV5Tuple, V5Selection v5Selection) {
        String detail = "automatic_true";
        IXQEQueryNode[] children = abstractV5Tuple.getChildren();
        for (int childPos = 0; childPos < children.length; ++childPos) {
            IXQEQueryNode currChild = children[childPos];
            if (currChild.getType() == 201085) {
                detail = SetDataItemDetailProperty.resolveDetailPropertyForMemberFnc((V5MemberFunction)currChild, v5Selection);
            } else if (currChild.getType() == 201030) {
                Object v5MultiPartIdDetail = SetDataItemDetailProperty.resolveDetailPropertyForV5MultiPartIdentifier((V5MultiPartIdentifier)currChild, v5Selection);
                detail = (String)v5MultiPartIdDetail;
            } else if (currChild.isOfCategory(201060)) {
                detail = SetDataItemDetailProperty.resolveDetailPropertyForBoundDataItemReference(currChild);
            }
            if (detail.equals("automatic")) {
                return "automatic";
            }
            if (!detail.equals("automatic_false") && !detail.equals("false")) continue;
            return detail;
        }
        return detail;
    }

    private static String resolveDetailPropertyForMemberFnc(V5MemberFunction definition, V5Selection v5Selection) {
        String detail = SetDataItemDetailProperty.genericResolveDetailProperty(definition.getChild(0), v5Selection);
        return detail;
    }

    private static String genericResolveDetailProperty(IXQEQueryNode definition, V5Selection v5Selection) {
        String detail = "automatic_true";
        if (definition.isOfTypes(summaryTypes)) {
            return "automatic_false";
        }
        if (definition.getType() == 201030) {
            Object v5MultiPartIdDetail = SetDataItemDetailProperty.resolveDetailPropertyForV5MultiPartIdentifier((V5MultiPartIdentifier)definition, v5Selection);
            detail = (String)v5MultiPartIdDetail;
        } else if (definition.isOfCategory(201060)) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForBoundDataItemReference(definition);
        } else if (definition.isOfCategory(201123)) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForAbstractV5tuple((AbstractV5Tuple)definition, v5Selection);
        } else if (definition.getType() == 201085) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForMemberFnc((V5MemberFunction)definition, v5Selection);
        } else if (definition.getType() == 201017) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForIfExpression((V5IfExpression)definition, v5Selection);
        } else if (definition.getType() == 201113) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForValueFunction((V5ValueFunction)definition, v5Selection);
        } else if (definition.getType() == 201014) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForValueExpression((V5ValueExpression)definition, v5Selection);
        } else if (definition.getType() == 201040) {
            detail = SetDataItemDetailProperty.resolveDetailPropertyForScalarFunction((V5ScalarFunction)definition, v5Selection);
        }
        return detail;
    }

    private static String resolveDetailPropertyForBoundDataItemReference(IXQEQueryNode definition) {
        String detail = "automatic_true";
        V5BoundDataItemReference boundDataItemRef = (V5BoundDataItemReference)definition;
        V5DataItem refV5DataItem = boundDataItemRef.getRefDataItem();
        if (refV5DataItem != null) {
            detail = refV5DataItem.getDetailProperty();
        } else {
            boundDataItemRef.throwInternalError("boundDataItemRef.getRefDataItem() == null");
        }
        return detail;
    }

    private static String resolveDetailPropertyForValueExpression(V5ValueExpression definition, V5Selection v5Selection) {
        IXQEQueryNode[] children;
        String detail = "automatic_true";
        for (IXQEQueryNode currChild : children = definition.getChildren()) {
            detail = SetDataItemDetailProperty.genericResolveDetailProperty(currChild, v5Selection);
            if (!detail.equals("automatic_false") && !detail.equals("false")) continue;
            return detail;
        }
        return detail;
    }

    private static String resolveDetailPropertyForScalarFunction(V5ScalarFunction definition, V5Selection v5Selection) {
        IXQEQueryNode[] children;
        String detail = "automatic_true";
        for (IXQEQueryNode currChild : children = definition.getChildren()) {
            detail = SetDataItemDetailProperty.genericResolveDetailProperty(currChild, v5Selection);
            if (!detail.equals("automatic_false") && !detail.equals("false")) continue;
            return detail;
        }
        return detail;
    }

    private static String resolveDetailPropertyForValueFunction(V5ValueFunction valueExpr, V5Selection v5Selection) {
        String detail = SetDataItemDetailProperty.genericResolveDetailProperty(valueExpr.getChild(0), v5Selection);
        return detail;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem = (V5DataItem)node;
        String detail = "true";
        detail = this.resolveDetailProperty(v5DataItem, environment);
        v5DataItem.setStringPropertyValue("detail", detail);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query != null && !query.isReferenced()) {
            return false;
        }
        boolean status = v5DataItem.getDetailProperty().equals("automatic");
        if (!status) {
            this.traceNodeCondition(false, "This 'detail' property value has been set already.", trace);
            return false;
        }
        V5Selection v5Selection = (V5Selection)v5DataItem.getAncestorOfType(101009);
        if (v5Selection == null) {
            this.traceNodeCondition(false, "This node is not within a V5Selection.", trace);
            return false;
        }
        String detail = this.resolveDetailProperty(v5DataItem, environment);
        if (detail == "automatic") {
            status = false;
            String s1 = "The 'detail' property value of a referenced V5DataItem has not been set yet.";
            this.traceNodeCondition(status, "The 'detail' property value of a referenced V5DataItem has not been set yet.", trace);
        }
        return status;
    }
}

