/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.result.V5DetailContext;
import com.cognos.xqe.ast.v5.result.V5MasterContext;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class SetSingleQueryMasterDetailQueries
extends Transformation {
    public SetSingleQueryMasterDetailQueries() {
        this.mName = "Set single query master detail cloned queries.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101059};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet qSet = (V5QuerySet)node.getAncestorOfType(101002);
        V5MasterDetailLink link = (V5MasterDetailLink)node;
        V5MasterContext master = (V5MasterContext)link.getChild(0);
        V5QueryResultDefinition qrdMaster = qSet.getQRD(master.getRefQueryResultDefinition());
        qrdMaster.getV5Query().setSingleQueryMasterDetail(true);
        V5DetailContext detail = (V5DetailContext)link.getChild(1);
        V5QueryResultDefinition qrdDetail = qSet.getQRD(detail.getRefQueryResultDefinition());
        qrdDetail.getV5Query().setSingleQueryMasterDetail(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean singleQuery = node.getBooleanPropertyValue("singleQuery");
        if (singleQuery != null && singleQuery.booleanValue()) {
            this.traceQueryCondition(true, "Single query master-detail link need to be processed.", environment.getTrace());
        } else {
            this.traceQueryCondition(false, "This is not single query master-detail link.", environment.getTrace());
        }
        return Boolean.TRUE.equals(singleQuery);
    }
}

