/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class SetTMRDirectQueryProcessing
extends Transformation {
    public SetTMRDirectQueryProcessing() {
        this.mName = "Set TMR Direct query processing.";
        this.mPassNumbers = new int[]{25};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        environment.getMultiRequestContext().setRequestProcessing(MultiRequestContext.RequestProcessing.DATABASEONLY);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query v5Query = (V5Query)node;
        if (!v5Query.isReferenced()) {
            this.traceQueryCondition(false, "There query is not referenced.", trace);
            return false;
        }
        String queryProcessing = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName());
        if (queryProcessing == null) {
            this.traceQueryCondition(false, "There is no query processing hint specified.", trace);
            return false;
        }
        if (environment.getMultiRequestContext().getRequestProcessing().equals((Object)MultiRequestContext.RequestProcessing.DATABASEONLY)) {
            this.traceQueryCondition(false, "Transformation already applied.", trace);
            return false;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!config.getBooleanProperty("qsAllowDatabaseOnlyForPA", false) || !queryProcessing.equals("databaseOnly")) {
            this.traceQueryCondition(false, "Query hint is not database only or should not be checked.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The environment request hint can be set to database only.", trace);
        return true;
    }
}

