/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class ThrowExceptionForInvalidAggregate
extends Transformation {
    public ThrowExceptionForInvalidAggregate() {
        this.mName = "Throw exception if there is any invalid aggregate on v5 data item";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 101004) {
            parent = parent.getParent();
        }
        if (parent.getType() == 101003) {
            String aggregate = ((V5DataItem)parent).getAggregateProperty();
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregationNonMeasureDataItem, aggregate, ((V5DataItem)parent).getNameProperty());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5BoundModelIdentifier modelIdentifier = (V5BoundModelIdentifier)node;
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        if (metaData == null) {
            this.traceNodeCondition(false, "Invalid bound model identifier.", trace);
            return false;
        }
        IXQEQueryNode parent = modelIdentifier.getParent();
        if (parent.getType() == 101004) {
            parent = parent.getParent();
        }
        if (parent.getType() == 101003 && ((V5DataItem)parent).isReferenced()) {
            V5DataItem di = (V5DataItem)parent;
            V5Selection selection = (V5Selection)di.getAncestorOfType(101009);
            if (selection != null && !selection.getAutoSummary()) {
                this.traceNodeCondition(false, "Auto summery false.", trace);
                return false;
            }
            boolean isMeasureOrCalculation = ((V5BoundModelIdentifier)node).isMeasure() || ((V5BoundModelIdentifier)node).isCalculation() || ((V5BoundModelIdentifier)node).isFactQueryItem();
            String aggregate = di.getAggregateProperty();
            IDataType v5DataType = ((V5BoundModelIdentifier)node).getDataType();
            if (isMeasureOrCalculation || aggregate == null || v5DataType == null) {
                this.traceNodeCondition(false, "Data item is measure or no aggregate.", trace);
                return false;
            }
            if (!this.isSupportedAggregation(v5DataType, aggregate)) {
                this.traceNodeCondition(true, "Invalid aggregation type on dataitem.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "Valid aggregate on dataitem.", trace);
        return false;
    }

    private boolean isSupportedAggregation(IDataType v5DataType, String aggregate) {
        return !v5DataType.isDatetime() && !v5DataType.isTextType() || !"total".equals(aggregate) && !"average".equals(aggregate) && !"standardDeviation".equals(aggregate) && !"variance".equals(aggregate) && !"sum".equals(aggregate);
    }
}

