/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceSetExpression;

public class CoerceSetExpressionAllArgs
extends AbstractCoerceSetExpression {
    public CoerceSetExpressionAllArgs() {
        this.mName = "Coerce Set Expression for all arguments";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201039, 201037};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (int idxChild = 0; idxChild < node.getNumberChildren(); ++idxChild) {
            IXQEQueryNode child = node.getChild(idxChild);
            if (!this.childRequiresCoercion(node, child)) continue;
            CoerceSetExpressionAllArgs.coerceToSetExpression(child, nodeFactory);
        }
    }

    private boolean childRequiresCoercion(IXQEQueryNode node, IXQEQueryNode child) {
        if (node.getType() == 201039) {
            V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node;
            if (withinClause.getWithinClauseType() == 0 && V5ExpressionCheck.getExpressionType(child) == V5ExpressionTypeEnum.TUPLE) {
                V5ExpressionCheck.throwInvalidCoercionException(child, V5ExpressionTypeEnum.SET);
            } else {
                if (withinClause.getWithinClauseType() == 0 && V5ExpressionCheck.isExplicitProperty(child)) {
                    return false;
                }
                if (withinClause.getWithinClauseType() == 1 && !V5ExpressionCheck.isSetExpression(child) && V5ExpressionCheck.shouldBeCoercedToSet(child) && !V5ExpressionCheck.canBeCoercedToSet(child)) {
                    return false;
                }
            }
        } else if (node.getType() == 201037 && V5ExpressionCheck.isExplicitProperty(child)) {
            return false;
        }
        return this.requiresSetCoercion(child);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getType() == 201039 && ((V5AggregateWithinClause)node).getWithinClauseType() == 2) {
            this.traceNodeCondition(false, "Set coercion is not applied to WITHIN AGGREGATE.", trace);
            return false;
        }
        V5Query v5query = (V5Query)node.getAncestorOfType(101006);
        if (v5query == null) {
            this.traceNodeCondition(false, "The node isn't in a query", trace);
            return false;
        }
        if (v5query.isTabular() || v5query.isRelStyle()) {
            this.traceNodeCondition(false, "The node isn't in an OLAP query", trace);
            return false;
        }
        for (int idxChild = 0; idxChild < node.getNumberChildren() && !status; ++idxChild) {
            IXQEQueryNode child = node.getChild(idxChild);
            if (!this.childRequiresCoercion(node, child)) continue;
            status = true;
        }
        if (!status) {
            this.traceNodeCondition(status, "All the child nodes are set expressions.", trace);
        } else {
            this.traceNodeCondition(status, "One of the child nodes is not a set expression.", trace);
        }
        return status;
    }
}

