/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceValueExpression;

public final class CoerceValueExpressionArg2Level
extends AbstractCoerceValueExpression {
    public CoerceValueExpressionArg2Level(int passNumber) {
        this.mName = "Coerce Value Expressions - Second Argument Level or Distance";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[1];
        this.mTypes = new int[]{201045, 201046, 201062};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode valueExprNode = node.getChild(1);
        CoerceValueExpressionArg2Level.coerceToValueExpression(valueExprNode, nodeFactory);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = node.getNumberChildren() == 2;
        XQETrace trace = environment.getTrace();
        boolean bl = status = V5ExpressionCheck.getExpressionType(node.getChild(1)) != V5ExpressionTypeEnum.LEVEL;
        if (status) {
            status = CoerceValueExpressionArg2Level.requiresValueCoercion(node.getChild(1));
        }
        if (status) {
            this.traceNodeCondition(status, "The second child node is not a value expression.", trace);
        } else {
            this.traceNodeCondition(status, "The second child node is a value expression.", trace);
        }
        return status;
    }
}

