/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.util.Governors;
import java.util.HashSet;
import java.util.Set;

public final class CleanMixedDMRRelProperty
extends Transformation {
    public CleanMixedDMRRelProperty() {
        this.mName = "Finalize Mixed DMR and Relational.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{101055, 101006, 101049, 101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("mixedDMRRelational");
        if (node.getType() == 101055) {
            node.removeProperty("checkOLAPFuncOnRelDone");
            this.generateDummyRSAPIDatasetforSubQuery(environment, (V5QueryResultDefinition)node);
        } else if (node.getType() == 101006) {
            V5Query query = (V5Query)node;
            V5Source src = query.getV5Source();
            Object flag = src.getPropertyValue("needTabularStream");
            if (flag != null) {
                src.removeProperty("needTabularStream");
            }
            if (!query.isDMR()) {
                query.setPropertyValue("isDMR", Boolean.TRUE);
            }
            query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), Boolean.FALSE);
        }
    }

    protected void generateDummyRSAPIDatasetforSubQuery(PlanningEnvironment environment, V5QueryResultDefinition qrd) {
        V5QuerySet v5QuerySet = (V5QuerySet)qrd.getAncestorOfType(101002);
        V5Query query = qrd.getV5Query();
        Set<String> subqueriesThis = MixedDMRRelUtil.getSubQueryNamesFromV5Query(query, environment);
        if (subqueriesThis.isEmpty()) {
            return;
        }
        HashSet<String> allSubqueries = new HashSet<String>();
        MixedDMRRelUtil.getAllSubQueryNamesFromV5Query(query, environment, v5QuerySet, allSubqueries);
        if (subqueriesThis.size() == allSubqueries.size()) {
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataset rsapiDataset = (RSAPIDataset)qrd.getAncestorOfType(401005);
        RSAPIDataset tabDataset = (RSAPIDataset)nodeFactory.createNode(401005);
        tabDataset.setReturnDataItemNameInPartialDataset(environment);
        String subName = rsapiDataset.getName() + "_forPrePlanSubqueriesWrappedInTempDMRCube";
        Governors tabGovernors = query.getGovernors();
        tabDataset.setName(subName);
        tabDataset.setRefQueryName(subName);
        tabDataset.setGovernors(tabGovernors);
        tabDataset.setUseSAPMUNAsBusinessKey(rsapiDataset.isUseSAPMUNAsBusinessKey());
        V5QueryResultDefinition tabQRD = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        tabDataset.addChild(tabQRD);
        tabQRD.setPropertyValue("name", subName);
        tabQRD.setPropertyValue("refQuery", subName);
        V5Query tabQuery = (V5Query)nodeFactory.createNode(101006);
        tabQuery.setPropertyValue("name", subName);
        tabQuery.setPropertyValue("isTabular", Boolean.TRUE);
        tabQuery.setGovernors(tabGovernors);
        V5Source tabSource = (V5Source)nodeFactory.deepCopyNode(query.getV5Source());
        tabSource.removeProperty("needTabularStream");
        tabQuery.addChild(tabSource);
        V5Selection tabSelection = (V5Selection)nodeFactory.createNode(101009);
        tabSelection.setAutoSummary(false);
        tabQuery.addChild(tabSelection);
        IXQEQueryNode tabEdge = nodeFactory.createNode(101049);
        ((V5Edge)tabEdge).setEdgeID(0);
        tabEdge.setPropertyValue("name", "1");
        tabQRD.addChild(tabEdge);
        IXQEQueryNode tabEdgeGroup = nodeFactory.createNode(101050);
        tabEdge.addChild(tabEdgeGroup);
        V5ValueSet tabValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        tabValueSet.setPropertyValue("name", "3");
        tabValueSet.setIsReportDetail(Boolean.TRUE);
        tabEdgeGroup.addChild(tabValueSet);
        IXQEQueryNode tabGroupBody = nodeFactory.createNode(101051);
        tabGroupBody.setPropertyValue("name", "3_gb");
        tabGroupBody.setPropertyValue("RSAPIInfoCollected", Boolean.TRUE);
        tabValueSet.addChild(tabGroupBody);
        RSAPIEdge tabRsapiEdge = new RSAPIEdge();
        tabRsapiEdge.setName((String)tabEdge.getPropertyValue("name"));
        int edgeId = ((V5Edge)tabEdge).getEdgeID();
        tabRsapiEdge.setOrdinal(edgeId);
        tabEdge.setPropertyValue("RSAPIEdge", tabRsapiEdge);
        tabRsapiEdge.setDataset(tabDataset);
        tabDataset.addEdge(tabRsapiEdge);
        RSAPIEdgeRowset tabRowset = new RSAPIEdgeRowset();
        Boolean bNoDataMode = v5QuerySet.getBooleanPropertyValue(V5QuerySet.RequestHint.NO_DATA_MODE.getPropertyName());
        if (null != bNoDataMode) {
            tabRowset.setNoDataMode(bNoDataMode);
        }
        tabValueSet.setRSAPIEdgeRowset(tabRowset);
        tabRowset.setName((String)tabValueSet.getPropertyValue("name"));
        tabRowset.setRowsetId(0);
        tabRowset.setEdge(tabRsapiEdge);
        tabRsapiEdge.addRowset(tabRowset);
        tabRsapiEdge.setRootRowset(tabRowset);
        v5QuerySet.addChild(tabQuery);
        tabQuery.addChild(tabDataset);
        String diName = "a";
        IXQEQueryNode dataItem = nodeFactory.createNode(101003);
        dataItem.setPropertyValue("aggregate", "none");
        dataItem.setPropertyValue("name", diName);
        tabSelection.addChild(dataItem);
        dataItem.addChild(nodeFactory.createNode(201023));
        IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", diName);
        tabGroupBody.addChild(dataItemRef);
        tabRowset.setDataItem(0, RSAPIUtilities.transferV5DataItemToRSAPIDataItem((V5DataItemRef)dataItemRef, tabSelection, true));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Object b = node.getPropertyValue("mixedDMRRelational");
        boolean bl = status = b != null;
        if (status) {
            this.traceNodeCondition(status, "need to clean property.", trace);
        } else {
            this.traceNodeCondition(status, "don't clean.", trace);
        }
        return status;
    }
}

