/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.TreeSet;

public final class CloneV5DataItemForGroupBodySort
extends Transformation {
    public CloneV5DataItemForGroupBodySort() {
        this.mName = "Clone V5DataItem for GroupBody and GroupSort.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItem = valueSet.getRefDataItemProperty();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5Query v5Query = v5QRD.getV5Query();
        V5Selection selection = v5Query.getV5Selection();
        TreeSet<String> itemsInBodySort = new TreeSet<String>();
        TabStreamUtil.collectItemsInGroupBodySort(node, itemsInBodySort);
        ArrayList<IXQEQueryNode> childrenSameItem = new ArrayList<IXQEQueryNode>();
        TabStreamUtil.getChildrenValueSetSameRefItem(node.getParent(), node, refDataItem, childrenSameItem);
        for (IXQEQueryNode c : childrenSameItem) {
            TabStreamUtil.collectItemsInGroupBodySort(c, itemsInBodySort);
        }
        for (String item : itemsInBodySort) {
            if (!this.dataItemUsedInOtherValueSet(node, childrenSameItem, item, v5QRD)) continue;
            V5DataItem dataItem = selection.getDataItemByRefName(item);
            V5DataItem clonedItem = (V5DataItem)nodeFactory.deepCopyNode(dataItem);
            String newItemName = item + valueSet.getNameProperty();
            clonedItem.setNameProperty(newItemName);
            clonedItem.setPropertyValue("orgName", item);
            selection.addChild(clonedItem);
            this.updateGroupBodySortReference(node, item, newItemName);
            for (IXQEQueryNode c : childrenSameItem) {
                this.updateGroupBodySortReference(c, item, newItemName);
            }
        }
    }

    protected void updateGroupBodySortReference(IXQEQueryNode valueSet, String item, String newItemName) {
        IXQEQueryNode[] sorts;
        IXQEQueryNode[] groupBodys;
        for (IXQEQueryNode aBody : groupBodys = valueSet.getChildrenOfType(101051)) {
            IXQEQueryNode[] refItems;
            V5GroupBody groupBody = (V5GroupBody)aBody;
            for (IXQEQueryNode aItem : refItems = groupBody.getChildrenOfType(101015)) {
                V5DataItemRef ref = (V5DataItemRef)aItem;
                String refName = ref.getDataItemRefProperty();
                if (!refName.equals(item)) continue;
                ref.setPropertyValue("orgName", refName);
                ref.setPropertyValue("refDataItem", newItemName);
            }
        }
        for (IXQEQueryNode aSort : sorts = valueSet.getChildrenOfType(101056)) {
            V5SortItem sortItem = (V5SortItem)aSort;
            String refName = sortItem.getRefDataItem();
            if (!refName.equals(item)) continue;
            sortItem.setPropertyValue("refDataItem", newItemName);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String refDataItem;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (v5QRD != null && v5QRD.getPropertyValue("tabstreamDefinition") != null && !TabStreamUtil.useSameDataItemAsParent(refDataItem = ((V5ValueSet)node).getRefDataItemProperty(), node.getParent().getParent())) {
            TreeSet<String> itemsInBodySort = new TreeSet<String>();
            TabStreamUtil.collectItemsInGroupBodySort(node, itemsInBodySort);
            ArrayList<IXQEQueryNode> childrenSameItem = new ArrayList<IXQEQueryNode>();
            TabStreamUtil.getChildrenValueSetSameRefItem(node.getParent(), node, refDataItem, childrenSameItem);
            for (IXQEQueryNode c : childrenSameItem) {
                TabStreamUtil.collectItemsInGroupBodySort(c, itemsInBodySort);
            }
            if (!itemsInBodySort.isEmpty()) {
                for (String item : itemsInBodySort) {
                    if (!this.dataItemUsedInOtherValueSet(node, childrenSameItem, item, v5QRD)) continue;
                    status = true;
                }
            }
        }
        if (status) {
            this.traceNodeCondition(status, "need to clone V5DataItem for GroupBody and GroupSort.", trace);
        } else {
            this.traceNodeCondition(status, "V5DataItems for GroupBody and GroupSort are not used by other ValueSets.", trace);
        }
        return status;
    }

    protected boolean dataItemUsedInOtherValueSet(IXQEQueryNode node, ArrayList<IXQEQueryNode> childrenSameItem, String item, IXQEQueryNode v5QRD) {
        IXQEQueryNode[] valueSets;
        for (IXQEQueryNode valueSet : valueSets = v5QRD.getDescendantsOfType(101057, false)) {
            if (valueSet.equals(node) || childrenSameItem.contains(valueSet)) continue;
            String refDataItemName = ((V5ValueSet)valueSet).getRefDataItemProperty();
            if (refDataItemName.equals(item)) {
                return true;
            }
            TreeSet<String> itemsInBodySort = new TreeSet<String>();
            TabStreamUtil.collectItemsInGroupBodySort(valueSet, itemsInBodySort);
            if (!itemsInBodySort.contains(item)) continue;
            return true;
        }
        return false;
    }
}

