/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;

public final class DecomposePostAggregateDetailFilters
extends Transformation {
    public DecomposePostAggregateDetailFilters() {
        this.mName = "Decompose the expression of post-aggregate detail filter.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query;
        V5QuerySet v5QuerySet;
        V5QueryResultDefinition qrd;
        V5DetailFilter filter;
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, (V5Query)node.getAncestorOfType(101006));
        ArrayList<IXQEQueryNode> nonFacts = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> facts = new ArrayList<IXQEQueryNode>();
        TabStreamUtil.getNonFactsAndFactsInExpression(env.mEnvironment, node.getChild(0), false, 2, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC, nonFacts, facts);
        ArrayList<IXQEQueryNode> projectedNonFacts = new ArrayList<IXQEQueryNode>();
        ArrayList<Object> projectedLevelsOrProperties = new ArrayList<Object>();
        ArrayList<IXQEQueryNode> nonProjectedNonFacts = new ArrayList<IXQEQueryNode>();
        TabStreamUtil.getProjectedAndNonProjectedNonFacts(env, nonFacts, projectedNonFacts, projectedLevelsOrProperties, nonProjectedNonFacts);
        if (projectedNonFacts.isEmpty() && facts.isEmpty()) {
            V5DetailFilter filter2 = (V5DetailFilter)node;
            filter2.setPostAutoAggregation(false);
            if (!nonProjectedNonFacts.isEmpty()) {
                StringBuilder expStr = new StringBuilder();
                nonProjectedNonFacts.get(0).writeFormattedText(expStr);
                int aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PAADetailFilterNonFactNonProj, expStr.toString()));
            }
            return;
        }
        if (!(nonProjectedNonFacts.isEmpty() || projectedNonFacts.isEmpty() && facts.isEmpty())) {
            StringBuilder expStr = new StringBuilder();
            nonProjectedNonFacts.get(0).writeFormattedText(expStr);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_PAADetailFilterNonFactNonProjAndFact, expStr.toString());
        }
        if (!projectedNonFacts.isEmpty() && projectedNonFacts.size() > 1 && facts.isEmpty() && (filter = (V5DetailFilter)node).getChild(0).getType() == 201003 && ((V5LogicalExpression)filter.getChild(0)).getSubType() == 1 && !(qrd = TabStreamUtil.getReferencedQRD(v5QuerySet = (V5QuerySet)(v5Query = (V5Query)filter.getAncestorOfType(101006)).getAncestorOfType(101002), v5Query)).isList()) {
            IXQEQueryNode[] edges;
            boolean doRemoveFilter = true;
            for (IXQEQueryNode edge : edges = qrd.getChildrenOfType(101049)) {
                IXQEQueryNode[] edgeGroups = edge.getDescendantsOfType(101050, false);
                boolean noneRefDataItems = true;
                for (IXQEQueryNode edgeGroup : edgeGroups) {
                    int numOfRefDataItemByPath = 0;
                    if (edgeGroup.getChildrenOfType(101050).length != 0) continue;
                    String refDataItemName = ((V5ValueSet)edgeGroup.getChildrenOfType(101057)[0]).getRefDataItemProperty();
                    for (IXQEQueryNode projectedNonFact : projectedNonFacts) {
                        V5DataItem di = projectedNonFact.getType() == 201060 ? ((V5BoundDataItemReference)projectedNonFact).getRefDataItem() : (V5DataItem)projectedNonFact;
                        if (!di.getNameProperty().equals(refDataItemName)) continue;
                        ++numOfRefDataItemByPath;
                        noneRefDataItems = false;
                    }
                    block3: for (IXQEQueryNode ancestorEdgeGroup = edgeGroup.getParent(); ancestorEdgeGroup != null && ancestorEdgeGroup.getType() == 101050; ancestorEdgeGroup = ancestorEdgeGroup.getParent()) {
                        refDataItemName = ((V5ValueSet)ancestorEdgeGroup.getChildrenOfType(101057)[0]).getRefDataItemProperty();
                        for (IXQEQueryNode projectedNonFact : projectedNonFacts) {
                            V5DataItem di = projectedNonFact.getType() == 201060 ? ((V5BoundDataItemReference)projectedNonFact).getRefDataItem() : (V5DataItem)projectedNonFact;
                            if (!di.getNameProperty().equals(refDataItemName)) continue;
                            ++numOfRefDataItemByPath;
                            continue block3;
                        }
                    }
                    if (numOfRefDataItemByPath != projectedNonFacts.size()) continue;
                    doRemoveFilter = false;
                    break;
                }
                if (!doRemoveFilter) break;
                if (!noneRefDataItems) continue;
            }
            if (doRemoveFilter) {
                filter.detach();
                int aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PAAORDetailFilterProjNonFactNotInSingleEdgePath, ((V5DetailFilter)node).getOriginalExpression()));
                return;
            }
        }
        node.setPropertyValue("wrapTo", "none");
        if (projectedNonFacts.isEmpty()) {
            TabStreamUtil.decomposeExpression(env, node.getChild(0), false, null, 2, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
        } else {
            for (int i = 0; i < projectedNonFacts.size(); ++i) {
                IXQEQueryNode nonFact = projectedNonFacts.get(i);
                Object levelOrProperty = projectedLevelsOrProperties.get(i);
                V5DataItemToLevelAttributeWrapper prop = null;
                prop = levelOrProperty instanceof V5DataItemToLevelWrapper ? TabStreamUtil.getLevelKeyProperty(env, (V5DataItemToLevelWrapper)levelOrProperty) : (V5DataItemToLevelAttributeWrapper)levelOrProperty;
                V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)env.mFactory.createNode(201116);
                newNode.setIdentifier(prop.getV5UniqueName());
                newNode.setMetadata(prop);
                nonFact.exchange(newNode);
            }
            for (IXQEQueryNode fact : facts) {
                boolean bDecomp = false;
                bDecomp = fact.getType() == 101003 ? TabStreamUtil.needDecompose(environment, (V5DataItem)fact) : TabStreamUtil.needDecomposeExpression(environment, fact, false, 1, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
                TabStreamUtil.decomposeExpression(env, fact, !bDecomp, null, 1, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
            }
        }
        MixedDMRRelUtil.convertOLAPUnsupportedExpr(env.mFactory, node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet;
        V5QueryResultDefinition qrd;
        V5Source src;
        Object cube;
        V5Query query;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String flag = (String)node.getPropertyValue("wrapTo");
        if (flag == null && (query = (V5Query)node.getAncestorOfType(101006)) != null && (cube = (src = query.getV5Source()).getPropertyValue("needTabularStream")) instanceof CubeWrapper && (qrd = TabStreamUtil.getReferencedQRD(querySet = (V5QuerySet)query.getAncestorOfType(101002), query)) != null && qrd.getPropertyValue("scope") != null) {
            V5DetailFilter filter = (V5DetailFilter)node;
            status = filter.getPostAutoAggregation();
        }
        if (status) {
            this.traceNodeCondition(status, "need to decompose the expression of post-aggregate detail filter.", trace);
        } else {
            this.traceNodeCondition(status, "don't decompose post-aggregate detail filter.", trace);
        }
        return status;
    }
}

