/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryItem;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.dmr.ReplaceDMRBoundIdentifierWithExpression;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.ConvertV5BetweenToANDCondition;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MixedDMRRelUtil {
    public static final String OLAPFUNC_ON_REL = "OLAPFunctionOnRelational[@enabled]";
    public static final String OLAPFUNC_ON_REL_LIST_XTAB = "list_crosstab";
    public static final String OLAPFUNC_ON_REL_LIST = "list";
    public static final String OLAPFUNC_ON_REL_XTAB = "crosstab";
    public static final String OLAPFUNCONREL_CHECK_DONE = "checkOLAPFuncOnRelDone";
    public static final int ACTION_NONE = 0;
    public static final int ACTION_WARNING = 1;
    public static final int ACTION_ERROR_OLAPFUNC_REL = 2;
    public static final String MIXED_DMR_REL = "mixedDMRRelational";
    public static final String WRAP_TYPE = "wrapType";
    public static final String WRAP_NAME = "wrapName";
    public static final String WRAP_NAME_SP = "_";
    public static final String WRAP_OWNERNAME = "wrapOwnerName";
    public static final String WRAP_REFOBJNAME = "wrapRefObjectName";
    public static final String WRAP_RSAPIITEM = "rsapiItem";
    public static final String WRAP_MULTI_RSAPIITEMS = "multiRsapiItems";
    public static final int WRAP_TYPE_MEASURE = 0;
    public static final int WRAP_TYPE_LEVEL = 1;
    public static final int WRAP_TYPE_LEVEL_PROP = 2;
    public static final String ERR_UNSUPPORTED = "not supported.";
    public static final String KEY_WORD_DMR = "dmr";
    public static final String WRAP_VALUE_SUMMARY_FUNCTION = "wrapValueSummary";
    public static final String RSAPIDATASET_PREPLAN = "_forPrePlanSubqueriesWrappedInTempDMRCube";
    public static final int[] UNSUPPORTED_OLAPFUNCTION = new int[]{201045, 201046, 201053, 201062, 201094, 201054, 201057, 201067, 201068, 201072, 201077, 201078, 201079, 201080, 201081, 201132, 201131, 201088, 201090, 201093, 201095, 201096, 201130, 201102, 201148, 201129, 201128, 201111, 201074, 201064, 201092, 201073, 201149};
    public static final int[] SCALARTYPES = new int[]{201041, 201109, 201055, 201051, 201040, 201042, 201065, 201033, 201014, 201035, 201025};
    public static final int[] V5OLAPCONSTRUCT = new int[]{201121, 201122, 201123, 201039, 201034, 201032};

    public static boolean denyOLAPFuncOnRelInList(PlanningEnvironment environment) {
        String v = MixedDMRRelUtil.getOLAPFuncOnRelSetting(environment);
        return !v.contains(OLAPFUNC_ON_REL_LIST);
    }

    public static boolean denyOLAPFuncOnRelInXtab(PlanningEnvironment environment) {
        String v = MixedDMRRelUtil.getOLAPFuncOnRelSetting(environment);
        return !v.contains(OLAPFUNC_ON_REL_XTAB);
    }

    protected static String getOLAPFuncOnRelSetting(PlanningEnvironment environment) {
        String v = (String)environment.getMultiRequestContext().fetchXQEConfigurationProperty(OLAPFUNC_ON_REL, OLAPFUNC_ON_REL_LIST_XTAB);
        if (v != null) {
            return v;
        }
        return OLAPFUNC_ON_REL_LIST_XTAB;
    }

    public static void applyActions(int action, PlanningEnvironment env, IXQEQueryNode node) {
        if (action != 0) {
            MixedDMRRelUtil.checkUnSupportedOLAPFunctionsOverRelationalExpr(env, node);
        }
        if ((action & 2) == 2) {
            MixedDMRRelUtil.checkthrowOLAPFuncOnRelError(env, node.getChild(0), true);
        }
        if ((action & 1) == 1) {
            MixedDMRRelUtil.checkthrowOLAPFuncOnRelError(env, node.getChild(0), false);
        }
    }

    public static boolean containRelationals(IXQEQueryNode item, StringBuilder relStr) {
        IXQEQueryNode[] whichOne;
        List<IXQEQueryNode> funcs = item.getDescendantsOfTypeOrdered(201031, true);
        for (IXQEQueryNode iXQEQueryNode : funcs) {
            if (iXQEQueryNode.getPropertyValue(WRAP_VALUE_SUMMARY_FUNCTION) != Boolean.TRUE) continue;
            return true;
        }
        List<IXQEQueryNode> modelObjects = item.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode obj : modelObjects) {
            IMetadata metaData = ((V5BoundModelIdentifier)obj).getMetadata();
            if (metaData.getObjectType() != MetadataType.QUERY_ITEM || ((IQueryItem)metaData).getLevel() != null) continue;
            if (relStr != null) {
                relStr.append(((V5BoundModelIdentifier)obj).getNativeName());
            }
            return true;
        }
        int[] nArray = new int[]{201060, 201097, 201103};
        List<IXQEQueryNode> refItems = item.getDescendantsOfTypesOrdered(nArray, true);
        for (IXQEQueryNode ref : refItems) {
            if (ref.getType() == 201060) {
                V5BoundDataItemReference refObj = (V5BoundDataItemReference)ref;
                if (!refObj.isQueryRefItem()) continue;
                if (relStr != null) {
                    relStr.append(refObj.getNativeName());
                }
                return true;
            }
            if (relStr != null) {
                if (ref.getType() == 201097) {
                    V5BoundQueryItemReference queryItemRef = (V5BoundQueryItemReference)ref;
                    relStr.append(queryItemRef.getNativeName());
                } else {
                    V5BoundSQLQueryItemReference sqlItemRef = (V5BoundSQLQueryItemReference)ref;
                    relStr.append(sqlItemRef.getNativeName());
                }
            }
            return true;
        }
        List<IXQEQueryNode> fncs = item.getDescendantsOfTypesOrdered(SCALARTYPES, true);
        IXQEQueryNode[] fncsArray = fncs.toArray(new IXQEQueryNode[fncs.size()]);
        boolean b = DecomposeScalarFunction.checkScalarFunctions(fncsArray, whichOne = new IXQEQueryNode[]{null});
        if (b && relStr != null) {
            relStr.append(((AbstractV5ValueExpression)whichOne[0]).getNativeName());
        }
        return b;
    }

    public static boolean checkSlicers(IXQEQueryNode[] slicers, int action, PlanningEnvironment env) {
        if (slicers.length == 0) {
            return false;
        }
        if (action == 0) {
            return true;
        }
        for (IXQEQueryNode slicer : slicers) {
            MixedDMRRelUtil.checkthrowOLAPFuncOnRelSlicer(slicer, action, env);
        }
        return true;
    }

    public static void checkthrowOLAPFuncOnRelSlicer(IXQEQueryNode slicer, int action, PlanningEnvironment env) {
        MixedDMRRelUtil.checkUnSupportedOLAPFunctionsOverRelationalExpr(env, slicer);
        if ((action & 2) == 2) {
            MixedDMRRelUtil.checkthrowOLAPFuncOnRelError(env, slicer.getChild(0), true);
        }
        if ((action & 1) == 1) {
            StringBuilder exp = new StringBuilder();
            ((V5SimpleNode)slicer.getChild(0)).writeFormattedText(exp);
            int aSeverity = 1;
            env.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_slicerContainsRelationalExpression, exp.toString()));
        }
    }

    public static void checkthrowOLAPFuncOnRelError(PlanningEnvironment env, IXQEQueryNode expr, boolean bWarnOrError) {
        IXQEQueryNode[] children;
        if (!expr.isOfCategory(201120)) {
            return;
        }
        V5SimpleNode simpleNode = (V5SimpleNode)expr;
        StringBuilder relStr = new StringBuilder();
        if (expr.isOfCategories(V5OLAPCONSTRUCT) && MixedDMRRelUtil.containRelationals(expr, relStr)) {
            StringBuilder expStr = new StringBuilder();
            simpleNode.writeFormattedText(expStr);
            if (bWarnOrError) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_OLAPFunctionOnRelational, expStr.toString(), relStr.toString());
            }
            int aSeverity = 1;
            env.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_OLAPFunctionOverRelationalExpression, expStr.toString(), relStr.toString()));
        }
        for (IXQEQueryNode child : children = expr.getChildren()) {
            MixedDMRRelUtil.checkUnSupportedOLAPFunctionsOverRelationalExpr(env, child);
        }
    }

    public static void checkUnSupportedOLAPFunctionsOverRelationalExpr(PlanningEnvironment env, IXQEQueryNode expr) {
        IXQEQueryNode[] children;
        if (!expr.isOfCategory(201120)) {
            return;
        }
        V5SimpleNode simpleNode = (V5SimpleNode)expr;
        if (!simpleNode.isOLAPConstruct() && MixedDMRRelUtil.containRelationals(expr, null)) {
            RefineAutomaticXtab.AggrTypeEnum aggrType;
            IXQEQueryNode fnc = simpleNode.getAncestorOfTypes(UNSUPPORTED_OLAPFUNCTION);
            if (fnc != null && (aggrType = RefineAutomaticXtab.determineAggrType(env, expr, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC)) == RefineAutomaticXtab.AggrTypeEnum.NONE) {
                StringBuilder expStr = new StringBuilder();
                fnc.writeFormattedText(expStr);
                if (fnc.getType() == 201111 || fnc.getType() == 201074 || fnc.getType() == 201064) {
                    throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedOLAPOnMultiSetsOnRelStyle, expStr.toString());
                }
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedOLAPOnRelStyle, expStr.toString());
            }
            return;
        }
        for (IXQEQueryNode child : children = expr.getChildren()) {
            MixedDMRRelUtil.checkUnSupportedOLAPFunctionsOverRelationalExpr(env, child);
        }
    }

    public static boolean isReportSummaryDataItem(V5QueryResultDefinition v5QRD, V5DataItem dataItem) {
        IXQEQueryNode[] valueSets;
        boolean b = false;
        String name = dataItem.getNameProperty();
        for (IXQEQueryNode vs : valueSets = v5QRD.getDescendantsOfType(101057, false)) {
            String refDataItem = ((V5ValueSet)vs).getRefDataItemProperty();
            if (!refDataItem.equals(name)) continue;
            if (TabStreamUtil.getReportSummaryDetailEdgeGroup((V5ValueSet)vs, dataItem, null) == null) {
                return false;
            }
            if (!b) {
                b = true;
                continue;
            }
            return false;
        }
        return b;
    }

    public static void checkthrowWarningReportSummaryWithinSet(PlanningEnvironment env, V5DataItem item) {
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)item.getFirstDescendantOfTypeOrdered(201039, false);
        if (withinClause.getWithinClauseType() != 1) {
            V5DataItem withitem = (V5DataItem)withinClause.getFirstDescendantOfTypeOrdered(101003, false);
            int aSeverity = 1;
            env.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_convertWithinSetToWithinDetailRelXtab, item.getNameProperty(), withitem.getNameProperty(), withitem.getNameProperty()));
        }
    }

    public static MixedDMRRelParam createParam() {
        MixedDMRRelUtil util = new MixedDMRRelUtil();
        return util.new MixedDMRRelParam();
    }

    protected static boolean needOverride(String newAggr, String oldAggr) {
        if (newAggr == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(newAggr) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
            return false;
        }
        if (RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(newAggr) != RefineAutomaticXtab.AggrTypeEnum.CALCULATED) {
            return true;
        }
        return oldAggr == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(oldAggr) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC;
    }

    protected static void pickUpAggregateRollUpFromTopMost(V5DataItem dataItem, String[] aggrRollUp) {
        aggrRollUp[0] = dataItem.getAggregateProperty();
        aggrRollUp[1] = dataItem.getRollupAggregateProperty();
        aggrRollUp[2] = dataItem.getNameProperty();
        while (dataItem.getParent().getType() == 101003) {
            dataItem = (V5DataItem)dataItem.getParent();
            String aggr = dataItem.getAggregateProperty();
            String rollUp = dataItem.getRollupAggregateProperty();
            if (MixedDMRRelUtil.needOverride(aggr, aggrRollUp[0])) {
                aggrRollUp[0] = aggr;
            }
            if (MixedDMRRelUtil.needOverride(rollUp, aggrRollUp[1])) {
                aggrRollUp[1] = rollUp;
            }
            aggrRollUp[2] = dataItem.getNameProperty();
        }
    }

    public static int getWrapType(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String[] aggrRollUp) {
        return MixedDMRRelUtil.getWrapTypeWithDefaultAggr(tnode, param, aggrRollUp, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
    }

    public static int getWrapTypeWithDefaultAggr(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String[] aggrRollUp, RefineAutomaticXtab.AggrTypeEnum defaulAggr) {
        int rt = 0;
        IXQEQueryNode parent = tnode.getParent();
        if (parent.getType() == 101003) {
            RefineAutomaticXtab.AggrTypeEnum rollType;
            V5DataItem dataItem = (V5DataItem)parent;
            MixedDMRRelUtil.pickUpAggregateRollUpFromTopMost(dataItem, aggrRollUp);
            RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.AggrTypeEnum.NONE;
            aggrType = aggrRollUp[0] == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrRollUp[0]) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC ? RefineAutomaticXtab.determineAggrType(param.env, tnode.getChild(0), defaulAggr) : (RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrRollUp[0]) == RefineAutomaticXtab.AggrTypeEnum.CALCULATED ? RefineAutomaticXtab.determineAggrType(param.env, tnode.getChild(0), RefineAutomaticXtab.AggrTypeEnum.CALCULATED) : (RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrRollUp[0]) == RefineAutomaticXtab.AggrTypeEnum.NONE && defaulAggr == RefineAutomaticXtab.AggrTypeEnum.CALCULATED ? RefineAutomaticXtab.determineAggrType(param.env, tnode.getChild(0), RefineAutomaticXtab.AggrTypeEnum.CALCULATED) : RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrRollUp[0])));
            if (aggrType == RefineAutomaticXtab.AggrTypeEnum.SUMMARIZE) {
                aggrType = RefineAutomaticXtab.resolveSummarized(param.env, tnode.getChild(0));
            }
            if (aggrType != RefineAutomaticXtab.AggrTypeEnum.NONE && RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrRollUp[0]) == RefineAutomaticXtab.AggrTypeEnum.NONE) {
                rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
                aggrRollUp[1] = rollType.getV5Name();
            }
            aggrRollUp[0] = aggrType.getV5Name();
            dataItem.setAggregateProperty(aggrRollUp[0]);
            if (aggrRollUp[1] == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrRollUp[1]) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
                rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
                aggrRollUp[1] = rollType.getV5Name();
            }
            dataItem.setRollupAggregateProperty(aggrRollUp[1]);
            if (!TabStreamUtil.isFactItem(dataItem)) {
                rt = 1;
            } else {
                rt = 0;
                aggrRollUp[0] = dataItem.getAggregateProperty();
                aggrRollUp[1] = dataItem.getRollupAggregateProperty();
            }
        } else {
            RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(param.env, tnode.getChild(0), defaulAggr);
            RefineAutomaticXtab.AggrTypeEnum rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
            if (aggrType == RefineAutomaticXtab.AggrTypeEnum.NONE) {
                rt = 1;
            } else {
                rt = 0;
                aggrRollUp[0] = aggrType.getV5Name();
                aggrRollUp[1] = rollType.getV5Name();
            }
        }
        return rt;
    }

    public static void wrapToNewOrExistLevel(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String label) {
        Integer wrappedType = tnode.getWrapType();
        if (wrappedType != null) {
            return;
        }
        if (label == null) {
            label = "TBlevel_";
        }
        tnode.setWrapType(new Integer(1));
        RelationalOlapDecorationNode exist = MixedDMRRelUtil.getTNodeWithSameDefinition(tnode, param, label);
        if (exist != null) {
            tnode.setWrapRefObjectName(exist.getWrapName());
            tnode.detachChildren();
        } else {
            int[] dimId = new int[]{-1};
            MixedDMRRelUtil.wrapToLevel(tnode, param, dimId, label);
        }
    }

    public static String wrapToLevel(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, int[] dimIdUse, String label) {
        IXQEQueryNode[] dataItems;
        if (label == null) {
            label = "TBlevel_";
        }
        tnode.setWrapType(new Integer(1));
        for (IXQEQueryNode item : dataItems = tnode.getDescendantsOfType(101003, false)) {
            item.extract();
        }
        IXQEQueryNode newExpr = param.factory.deepCopyNode(tnode.getChild(0));
        tnode.setExpression(newExpr);
        tnode.setLabel(label);
        tnode.setDataType(((V5SimpleNode)newExpr).getDataType());
        tnode.detachChildren();
        return MixedDMRRelUtil.assignLevelName(tnode, param, dimIdUse);
    }

    protected static String assignLevelName(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, int[] dimIdUse) {
        int dimId = 0;
        int levelId = 0;
        if (dimIdUse[0] < 0) {
            dimId = param.dimToLevel.size();
        } else {
            dimId = dimIdUse[0];
            levelId = param.dimToLevel.get(dimId);
            ++levelId;
        }
        param.dimToLevel.put(dimId, levelId);
        String wrapName = Integer.toString(dimId) + WRAP_NAME_SP + Integer.toString(levelId);
        tnode.setWrapName(wrapName);
        param.wrappedLevels.add(tnode);
        dimIdUse[0] = dimId;
        return wrapName;
    }

    public static String updateClonedTNodeWrappedToLevel(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, int[] dimIdUse) {
        IXQEQueryNode exp = tnode.getExpression();
        IXQEQueryNode newExpr = param.factory.deepCopyNode(exp);
        tnode.setExpression(newExpr);
        return MixedDMRRelUtil.assignLevelName(tnode, param, dimIdUse);
    }

    public static void wrapToLevelProperty(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String leveName, String propName, String label) {
        IXQEQueryNode[] dataItems;
        tnode.setWrapType(new Integer(2));
        tnode.setWrapOwnerName(leveName);
        tnode.setWrapName(propName);
        tnode.setLabel(label);
        for (IXQEQueryNode item : dataItems = tnode.getDescendantsOfType(101003, false)) {
            item.extract();
        }
        IXQEQueryNode newExpr = param.factory.deepCopyNode(tnode.getChild(0));
        tnode.setExpression(newExpr);
        tnode.setDataType(((V5SimpleNode)newExpr).getDataType());
        tnode.detachChildren();
        param.wrappedLevelProps.add(tnode);
    }

    public static RelationalOlapDecorationNode getTNodeWithSameDefinition(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String label) {
        int[] types = new int[]{101004};
        for (RelationalOlapDecorationNode t : param.wrappedLevels) {
            String labelWrap = t.getLabel();
            if (!labelWrap.equals(label) || !TabStreamUtil.isSameExpression(t.getExpression(), tnode.getChild(0), types)) continue;
            return t;
        }
        return null;
    }

    public static RelationalOlapDecorationNode getTNodeWithSameDefinition(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String[] aggrRollUpLabel) {
        int[] types = new int[]{101004};
        for (RelationalOlapDecorationNode t : param.wrappedMeasures) {
            V5RollupAggregateEnum rollUpWrap;
            String aggrWrap = t.getAggregate();
            if (!aggrWrap.equals(aggrRollUpLabel[0]) || (rollUpWrap = t.getRollupAggregate()) != null && !rollUpWrap.getName().toLowerCase().equals(aggrRollUpLabel[1].toLowerCase()) || !TabStreamUtil.isSameExpression(t.getExpression(), tnode.getChild(0), types)) continue;
            return t;
        }
        return null;
    }

    public static void wrapToMeasure(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String[] aggrRollUpLabel) {
        Integer wrappedType = tnode.getWrapType();
        if (wrappedType != null) {
            return;
        }
        tnode.setWrapType(new Integer(0));
        RelationalOlapDecorationNode exist = MixedDMRRelUtil.getTNodeWithSameDefinition(tnode, param, aggrRollUpLabel);
        if (exist != null) {
            tnode.setWrapRefObjectName(exist.getWrapName());
            tnode.detachChildren();
            tnode.setDataType(((V5SimpleNode)exist).getDataType());
        } else if (MixedDMRRelUtil.setMeasureInfo(tnode, param, aggrRollUpLabel)) {
            tnode.extract();
        }
    }

    public static boolean setMeasureInfo(RelationalOlapDecorationNode tnode, MixedDMRRelParam param, String[] aggrRollUpLabel) {
        IXQEQueryNode[] dataItems;
        boolean b;
        if (aggrRollUpLabel[0].equals("calculated") && TabStreamUtil.needDecomposeExpression(param.env, tnode.getChild(0), false, 1, RefineAutomaticXtab.AggrTypeEnum.CALCULATED) && (b = MixedDMRRelUtil.decomposeExpression(param, tnode.getChild(0), false, 1))) {
            return true;
        }
        String wrapName = Integer.toString(param.wrappedMeasures.size());
        tnode.setWrapType(new Integer(0));
        tnode.setWrapName(wrapName);
        tnode.setAggregate(aggrRollUpLabel[0]);
        V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(aggrRollUpLabel[1]);
        tnode.setRollupAggregate(rollupAggregate);
        for (IXQEQueryNode item : dataItems = tnode.getDescendantsOfType(101003, false)) {
            item.extract();
        }
        IXQEQueryNode newExpr = param.factory.deepCopyNode(tnode.getChild(0));
        tnode.setExpression(newExpr);
        if (aggrRollUpLabel[2] != null) {
            tnode.setLabel(aggrRollUpLabel[2]);
        } else {
            tnode.setLabel(wrapName);
        }
        tnode.setDataType(((V5SimpleNode)newExpr).getDataType());
        tnode.detachChildren();
        param.wrappedMeasures.add(tnode);
        return false;
    }

    private static void resolveAutoMaticInCalculation(MixedDMRRelParam param, V5DataItem aDI) {
        String aggrStr = aDI.getAggregateProperty();
        RefineAutomaticXtab.AggrTypeEnum aggrType = null;
        String rollUpStr = aDI.getRollupAggregateProperty();
        if (aggrStr == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrStr) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
            aggrType = RefineAutomaticXtab.determineAggrType(param.env, aDI.getChild(0), RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
            aDI.setAggregateProperty(aggrType.getV5Name());
        } else {
            aggrType = RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggrStr);
        }
        if (rollUpStr == null || RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(rollUpStr) == RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC) {
            RefineAutomaticXtab.AggrTypeEnum rType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
            aDI.setRollupAggregateProperty(rType.getV5Name());
        }
    }

    public static boolean decomposeExpression(MixedDMRRelParam param, IXQEQueryNode expr, boolean bDecompose, int sepRules) {
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        if (!TabStreamUtil.useMetadataObjects(expr, true)) {
            return false;
        }
        boolean bDecompPoint = false;
        if (expr.isOfCategory(201120)) {
            V5SimpleNode simpleNode = (V5SimpleNode)expr;
            bDecompPoint = TabStreamUtil.checkDecomposePoint(simpleNode, sepRules);
        }
        if (bDecompPoint) {
            IXQEQueryNode[] children;
            if (!TabStreamUtil.needDecomposeExpression(param.env, expr, false, sepRules, RefineAutomaticXtab.AggrTypeEnum.CALCULATED)) {
                return false;
            }
            if ((sepRules & 1) != 1) {
                sepRules |= 1;
            }
            for (IXQEQueryNode child : children = expr.getChildren()) {
                if (expr.getType() == 201017 && child == children[0]) {
                    sepRules |= 4;
                }
                MixedDMRRelUtil.decomposeExpression(param, child, true, sepRules);
            }
            return true;
        }
        if (bDecompose) {
            if (expr.getType() == 101003) {
                boolean bNeedDecomp = false;
                MixedDMRRelUtil.resolveAutoMaticInCalculation(param, (V5DataItem)expr);
                bNeedDecomp = (sepRules & 2) != 2 ? TabStreamUtil.needDecompose(param.env, (V5DataItem)expr) : TabStreamUtil.needDecomposeExpression(param.env, expr.getChild(0), false, sepRules, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
                if (bNeedDecomp) {
                    return MixedDMRRelUtil.decomposeExpression(param, expr.getChild(0), bDecompose, sepRules);
                }
                RelationalOlapDecorationNode marker = (RelationalOlapDecorationNode)param.factory.createNode(601024);
                IXQEQueryNode child = expr.getChild(0);
                while (child.getType() == 101003) {
                    child = child.getChild(0);
                }
                child.insertParent(marker);
                String[] aggrRollUp = new String[]{null, null, null};
                int tp = MixedDMRRelUtil.getWrapTypeWithDefaultAggr(marker, param, aggrRollUp, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
                if (tp == 0) {
                    MixedDMRRelUtil.wrapToMeasure(marker, param, aggrRollUp);
                    expr.exchange(MixedDMRRelUtil.coerceToValue(marker, param.factory));
                } else {
                    expr.throwInternalError(ERR_UNSUPPORTED);
                }
            } else {
                RelationalOlapDecorationNode marker = (RelationalOlapDecorationNode)param.factory.createNode(601024);
                expr.insertParent(marker);
                String[] aggrRollUp = new String[]{null, null, null};
                int tp = MixedDMRRelUtil.getWrapTypeWithDefaultAggr(marker, param, aggrRollUp, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
                if (tp == 0) {
                    MixedDMRRelUtil.wrapToMeasure(marker, param, aggrRollUp);
                    MixedDMRRelUtil.coerceToValue(marker, param.factory);
                } else {
                    expr.throwInternalError(ERR_UNSUPPORTED);
                }
            }
            return true;
        }
        return false;
    }

    public static IXQEQueryNode coerceToValue(IXQEQueryNode tnode, IXQENodeFactory factory) {
        IXQEQueryNode tuple = factory.createNode(201110);
        tnode.insertParent(tuple);
        IXQEQueryNode value = factory.createNode(201113);
        tuple.insertParent(value);
        return value;
    }

    public static void collectWrappedMeasuresAndLevels(MixedDMRRelParam param) {
        IXQEQueryNode[] tnodes;
        param.dimToLevel = new HashMap();
        param.wrappedMeasures = new ArrayList();
        param.wrappedLevels = new ArrayList();
        param.wrappedLevelProps = new ArrayList();
        for (IXQEQueryNode tnode : tnodes = param.selection.getParent().getDescendantsOfType(601024, false)) {
            RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
            Integer tp = relOLAPDeco.getWrapType();
            if (tp == null || relOLAPDeco.getExpression() == null) continue;
            if (tp == 0) {
                param.wrappedMeasures.add(relOLAPDeco);
                continue;
            }
            if (tp == 1) {
                param.wrappedLevels.add(relOLAPDeco);
                String name = relOLAPDeco.getWrapName();
                int sp = name.indexOf(WRAP_NAME_SP);
                String dimName = name.substring(0, sp);
                String levelName = name.substring(sp + 1);
                int dimId = Integer.parseInt(dimName);
                int levelId = Integer.parseInt(levelName);
                if (param.dimToLevel.containsKey(dimId) && param.dimToLevel.get(dimId) >= levelId) continue;
                param.dimToLevel.put(dimId, levelId);
                continue;
            }
            if (tp != 2) continue;
            param.wrappedLevelProps.add(relOLAPDeco);
        }
    }

    public static CubeWrapper createDummyCube(MixedDMRRelParam param) {
        V5Query v5Query = (V5Query)param.selection.getParent();
        V5Source src = v5Query.getV5Source();
        String modelPath = null;
        String modelType = null;
        if (src != null) {
            modelPath = src.getModel();
            modelType = src.getModelType();
            if (modelPath != null && (modelPath = modelPath.trim()).length() == 0) {
                modelPath = null;
                modelType = null;
            }
        }
        if (modelPath == null) {
            V5QuerySet querySet = (V5QuerySet)v5Query.getAncestorOfType(101002);
            modelPath = querySet.getModelPath();
            modelType = querySet.getModelType();
            if (modelPath != null && (modelPath = modelPath.trim()).length() == 0) {
                modelPath = null;
                modelType = null;
            }
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)param.env.getExecutionEnvironment();
        MetricsService.startCollectingMetric((RequestEnvironment)param.env.getRequestEnvironment(), "mfwRequest");
        MetadataConnection con = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, execEnv, true);
        return new CubeWrapper(con, v5Query.getGovernors());
    }

    public static RelationalOlapDecorationNode getTNodeWrapToLevel(V5DataItem v5DataItem, MixedDMRRelParam param) {
        int idx;
        String hierPos;
        int pos;
        IHierarchy h;
        String name;
        IXQEQueryNode[] tnodes = v5DataItem.getDescendantsOfType(601024, false);
        boolean hasTNodeToLevel = false;
        for (IXQEQueryNode tnode : tnodes) {
            RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
            Integer tp = relOLAPDeco.getWrapType();
            if (tp == null) {
                String[] aggrRollUp = new String[]{null, null, null};
                tp = MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp);
            }
            if (tp != 1) continue;
            hasTNodeToLevel = true;
            break;
        }
        if (!hasTNodeToLevel) {
            return null;
        }
        CubeWrapper theCubeWrapper = MixedDMRRelUtil.createDummyCube(param);
        int i = -1;
        for (IXQEQueryNode tnode : tnodes) {
            RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
            ++i;
            Integer tp = relOLAPDeco.getWrapType();
            if (tp == null) {
                String[] aggrRollUp = new String[]{null, null, null};
                tp = MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp);
            }
            if (tp == 1) {
                Dimension dim = TabStreamUtil.createDimensionWrapper(theCubeWrapper, Integer.toString(i));
                relOLAPDeco.setMixedDMRRelationalHierarchy(dim.getDefaultHierarchy());
                continue;
            }
            Dimension measuresDim = theCubeWrapper.createAndReturnMeasuresDimension();
            relOLAPDeco.setMixedDMRRelationalHierarchy(measuresDim.getDefaultHierarchy());
        }
        MDXHierInfo hier = v5DataItem.getHierarchyInfo();
        for (i = 0; i < tnodes.length; ++i) {
            ((RelationalOlapDecorationNode)tnodes[i]).setMixedDMRRelationalHierarchy(null);
        }
        if (hier.getNumProjectedHierarchies() == 1 && (name = (h = hier.getProjectedHierarchy(0)).getName()).startsWith("TBhierarchy_") && (pos = Integer.parseInt(hierPos = name.substring((idx = name.lastIndexOf(WRAP_NAME_SP)) + 1))) < tnodes.length) {
            return (RelationalOlapDecorationNode)tnodes[pos];
        }
        return null;
    }

    public static IXQEQueryNode copyV5SourceForSubQuery(IXQENodeFactory nodeFactory, IXQEQueryNode querySetSource, IXQEQueryNode querySet) {
        V5Query query = ((V5QuerySet)querySetSource).getV5Query(MIXED_DMR_REL);
        V5Source src = query.getV5Source();
        IXQEQueryNode rtSrc = nodeFactory.deepCopyNode(src);
        ArrayList<V5Query> allCopiedSubQueries = new ArrayList<V5Query>();
        IXQEQueryNode[] subqueries = querySetSource.getChildrenOfType(101006);
        for (IXQEQueryNode v5QueryNode : subqueries) {
            IXQEQueryNode subQuery;
            V5Query orgV5Query = (V5Query)v5QueryNode;
            String v5QueryName = orgV5Query.getV5QueryName();
            if (v5QueryName.equals(MIXED_DMR_REL) || (subQuery = ((V5QuerySet)querySet).getV5Query(v5QueryName)) != null) continue;
            subQuery = nodeFactory.deepCopyNode(orgV5Query);
            querySet.addChild(subQuery);
            allCopiedSubQueries.add((V5Query)subQuery);
        }
        for (IXQEQueryNode iXQEQueryNode : allCopiedSubQueries) {
            MixedDMRRelUtil.reBindReferences(nodeFactory, iXQEQueryNode, ((V5Query)iXQEQueryNode).getV5Source(), querySet);
        }
        return rtSrc;
    }

    public static void reBindReferences(IXQENodeFactory nodeFactory, IXQEQueryNode expression, IXQEQueryNode source, IXQEQueryNode querySet) {
        IXQEQueryNode[] dataItemRefs;
        IXQEQueryNode[] queryItemRefs;
        for (IXQEQueryNode aItemRef : queryItemRefs = expression.getDescendantsOfType(201097, true)) {
            V5BoundQueryItemReference aQueryItemRef = (V5BoundQueryItemReference)aItemRef;
            String[] nameParts = aQueryItemRef.getNameParts();
            V5QueryItem queryItem = MixedDMRRelUtil.getRefQueryIntemInSource(nameParts, source);
            if (queryItem == null) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, aQueryItemRef.getIdentifier());
            }
            aQueryItemRef.setRefQueryItem(queryItem);
            aQueryItemRef.setRefDataItem(MixedDMRRelUtil.getDataItemReference(queryItem, source, querySet));
        }
        for (IXQEQueryNode aRef : dataItemRefs = expression.getDescendantsOfType(201060, true)) {
            V5BoundDataItemReference aDataItemRef = (V5BoundDataItemReference)aRef;
            if (!aDataItemRef.isQueryRefItem() && !aDataItemRef.isNestedQuerySetRefItem()) continue;
            String[] nameParts = aDataItemRef.getNameParts();
            V5DataItem dataItem = MixedDMRRelUtil.getRefDataItemInSource(nameParts, querySet);
            if (dataItem == null) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, aDataItemRef.getIdentifier());
            }
            aDataItemRef.setRefDataItem(dataItem);
            aDataItemRef.setIsQueryRefItem();
        }
    }

    protected static V5QueryItem getRefQueryIntemInSource(String[] nameParts, IXQEQueryNode source) {
        if (nameParts.length != 2) {
            return null;
        }
        List<IXQEQueryNode> queryOps = source.getDescendantsOfTypeOrdered(101018, false);
        for (IXQEQueryNode aQueryOp : queryOps) {
            String nameOperationQuery = (String)aQueryOp.getPropertyValue("name");
            if (!nameParts[0].equals(nameOperationQuery)) continue;
            IXQEQueryNode[] proj = aQueryOp.getChildrenOfType(101020);
            if (proj.length == 1) {
                IXQEQueryNode[] queryItems;
                for (IXQEQueryNode aQueryItem : queryItems = proj[0].getChildrenOfType(101022)) {
                    String queryItemName = ((V5QueryItem)aQueryItem).getName();
                    if (!nameParts[1].equals(queryItemName)) continue;
                    return (V5QueryItem)aQueryItem;
                }
            }
            return null;
        }
        return null;
    }

    protected static V5DataItem getDataItemReference(V5QueryItem v5QueryItem, IXQEQueryNode src, IXQEQueryNode querySet) {
        V5QueryRef firstSubV5Query = (V5QueryRef)src.getFirstDescendantOfTypeOrdered(101023, false);
        if (firstSubV5Query == null) {
            return null;
        }
        String name = firstSubV5Query.getRefQuery();
        V5Query orgV5Query = ((V5QuerySet)querySet).getV5Query(name);
        if (orgV5Query == null) {
            return null;
        }
        V5Selection selection = orgV5Query.getV5Selection();
        return selection.getDataItemByRefName(v5QueryItem.getName());
    }

    protected static V5DataItem getRefDataItemInSource(String[] nameParts, IXQEQueryNode querySet) {
        if (nameParts.length != 2) {
            return null;
        }
        V5Query query = ((V5QuerySet)querySet).getV5Query(nameParts[0]);
        if (query == null) {
            return null;
        }
        V5Selection selection = query.getV5Selection();
        return selection.getDataItemByRefName(nameParts[1]);
    }

    public static RelationalOlapDecorationNode getExistingLevelOrProperty(MixedDMRRelParam param, RelationalOlapDecorationNode tnode) {
        int[] types = new int[]{101003, 101004};
        for (RelationalOlapDecorationNode t : param.wrappedLevels) {
            if (!TabStreamUtil.isSameExpression(t.getExpression(), tnode.getChild(0), types)) continue;
            return t;
        }
        for (RelationalOlapDecorationNode t : param.wrappedLevelProps) {
            if (!TabStreamUtil.isSameExpression(t.getExpression(), tnode.getChild(0), types)) continue;
            return t;
        }
        return null;
    }

    public static RelationalOlapDecorationNode getLevelProperty(MixedDMRRelParam param, String levelName, String propName) {
        for (RelationalOlapDecorationNode t : param.wrappedLevelProps) {
            String lvlName = t.getWrapOwnerName();
            String pName = t.getWrapName();
            if (lvlName == null || pName == null || !lvlName.equals(levelName) || !pName.equals(propName)) continue;
            return t;
        }
        return null;
    }

    public static boolean cleanUpCaptionOnRelational(V5Query v5Query) {
        boolean bCleanUp = false;
        int[] types = new int[]{201050, 201098};
        List<IXQEQueryNode> caps = v5Query.getDescendantsOfTypesOrdered(types, false);
        Collections.reverse(caps);
        for (IXQEQueryNode cap : caps) {
            if (!MixedDMRRelUtil.canRemoveCaptionRoleValueOnRelational(cap, cap.getChild(1))) continue;
            V5LiteralValue literalValue = (V5LiteralValue)cap.getFirstChildByType(201026);
            MixedDMRRelUtil.invalidSecondArgumentForRoleValueFunction(v5Query, cap, literalValue);
            if (!literalValue.getValue().getString().equals("_memberCaption")) continue;
            literalValue.extract();
            cap.extract();
            bCleanUp = true;
        }
        return bCleanUp;
    }

    public static void invalidSecondArgumentForRoleValueFunction(V5Query v5Query, IXQEQueryNode node, V5LiteralValue literalValue) {
        List<IXQEQueryNode> modelObjects = node.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode obj : modelObjects) {
            IMetadata metaData = ((V5BoundModelIdentifier)obj).getMetadata();
            if (metaData.getObjectType() != MetadataType.QUERY_ITEM || ((IQueryItem)metaData).getLevel() != null) continue;
            String queryName = v5Query.getV5QueryName();
            String functionName = "rolevalue";
            int pos = 2;
            String expectedType = "memberSet, member, hierarchy, level";
            Boolean caption = node.getBooleanPropertyValue("convertedFromCaption");
            if (caption != null && caption.booleanValue()) {
                functionName = "caption";
                pos = 1;
                expectedType = "memberSet, member, level";
            }
            if (node.getAncestorOfType(101008) != null) {
                V5DetailFilter df = (V5DetailFilter)node.getAncestorOfType(101008);
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentForCaptionOrRolevalueInDetailFilter, queryName, (Object)df.getOriginalExpression(), (Object)pos, (Object)functionName, (Object)expectedType);
            }
            if (node.getAncestorOfType(101003) == null) continue;
            V5DataItem di = (V5DataItem)node.getAncestorOfType(101003);
            StringBuilder diExp = new StringBuilder();
            di.writeFormattedText(diExp);
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentForCaptionOrRolevalueInDataItem, queryName, (Object)di.getNameProperty(), (Object)diExp.toString(), (Object)pos, (Object)functionName, (Object)expectedType);
        }
    }

    protected static boolean canRemoveCaptionRoleValueOnRelational(IXQEQueryNode func, IXQEQueryNode child) {
        if (!MixedDMRRelUtil.containRelationals(child, null)) {
            return false;
        }
        int[] categories = new int[]{201121, 201122};
        IXQEQueryNode[] olapFuncs = func.getAncestorsOfCategories(categories);
        return olapFuncs.length == 0;
    }

    public static boolean needWrapValueSummaryFunctions(V5Query v5Query) {
        List<IXQEQueryNode> funcs = v5Query.getDescendantsOfTypeOrdered(201031, false);
        boolean r = false;
        for (IXQEQueryNode f : funcs) {
            IMetadata metadataObj;
            IXQEQueryNode firstObj;
            V5AggregateBreakClause brk;
            int subType = ((V5SimpleNode)f).getSubType();
            if (subType != 2 || (brk = ((V5AggregateFunction)f).getForClause()) != null && (brk.getSubType() == 0 || brk.getNumberChildren() != 0) || (firstObj = f.getChild(0)) == null || firstObj.getType() != 201116 || (metadataObj = ((V5BoundModelIdentifier)firstObj).getMetadata()) == null || metadataObj.getObjectType() != MetadataType.QUERY_ITEM || !(metadataObj instanceof IProperty)) continue;
            f.setPropertyValue(WRAP_VALUE_SUMMARY_FUNCTION, Boolean.TRUE);
            r = true;
        }
        return r;
    }

    public static void setRSAPIDataItem(IXQEQueryNode tnode, V5QueryResultDefinition qrd, V5ValueSet valueSet, String itemName, int flag) {
        IXQEQueryNode rsapiNode = qrd.getAncestorOfType(401005);
        V5Edge edge = (V5Edge)valueSet.getAncestorOfType(101049);
        String edgeName = (String)edge.getPropertyValue("name");
        String rowsetName = valueSet.getNameProperty();
        RSAPIDataItem item = null;
        RSAPIEdgeRowset rowSet = null;
        switch (flag) {
            case -1: {
                item = TabStreamUtil.getRSAPIDataItemByName(rsapiNode, edgeName, rowsetName, itemName);
                break;
            }
            case 0: {
                rowSet = MixedDMRRelUtil.getRowSetByName(rsapiNode, edgeName, rowsetName);
                if (rowSet == null || (rowSet = rowSet.getHeaderRowset()) == null) break;
                item = MixedDMRRelUtil.getDataItemByName(rowSet, itemName);
                break;
            }
            case 1: {
                rowSet = MixedDMRRelUtil.getRowSetByName(rsapiNode, edgeName, rowsetName);
                if (rowSet == null || (rowSet = rowSet.getFooterRowset()) == null) break;
                item = MixedDMRRelUtil.getDataItemByName(rowSet, itemName);
                break;
            }
            case 2: {
                rowSet = MixedDMRRelUtil.getRowSetByName(rsapiNode, edgeName, rowsetName);
                if (rowSet == null) break;
                item = rowSet.getRefDataItem();
                break;
            }
        }
        if (item != null) {
            ArrayList<RSAPIDataItem> lst = (ArrayList<RSAPIDataItem>)tnode.getPropertyValue(WRAP_MULTI_RSAPIITEMS);
            if (lst == null) {
                lst = new ArrayList<RSAPIDataItem>();
                tnode.setPropertyValue(WRAP_MULTI_RSAPIITEMS, lst);
            }
            lst.add(item);
        }
    }

    protected static RSAPIEdgeRowset getRowSetByName(IXQEQueryNode rsapiNode, String edgeName, String rowsetSetName) {
        RSAPIEdge[] rsapiEdges;
        if (rsapiNode.getType() != 401005) {
            return null;
        }
        for (RSAPIEdge aEdge : rsapiEdges = ((RSAPIDataset)rsapiNode).getEdges()) {
            RSAPIEdgeRowset[] rowsets;
            if (!aEdge.getName().equals(edgeName)) continue;
            for (RSAPIEdgeRowset aRowset : rowsets = aEdge.getRowsets()) {
                if (!aRowset.getName().equals(rowsetSetName)) continue;
                return aRowset;
            }
            break;
        }
        return null;
    }

    protected static RSAPIDataItem getDataItemByName(RSAPIEdgeRowset aRowset, String itemName) {
        RSAPIDataItem[] items;
        for (RSAPIDataItem item : items = aRowset.getDataItems()) {
            if (!item.getName().equals(itemName)) continue;
            return item;
        }
        return null;
    }

    public static void unwindDimentionalObjectsAndSetScopes(PlanningEnvironment env, V5DataItemToMeasureWrapper measure) {
        IXQEQueryNode expr = measure.getBinaryExpression();
        if (expr == null || expr.getPropertyValue(WRAP_VALUE_SUMMARY_FUNCTION) != Boolean.TRUE) {
            return;
        }
        IXQEQueryNode firstObj = expr.getChild(0);
        if (firstObj == null || firstObj.getType() != 201116) {
            return;
        }
        MixedDMRRelUtil.unwindLevelPropertyToRelational(env, firstObj);
    }

    public static void unwindLevelPropertyToRelational(PlanningEnvironment env, IXQEQueryNode firstObj) {
        IMetadata metadataObj = ((V5BoundModelIdentifier)firstObj).getMetadata();
        if (metadataObj == null || metadataObj.getObjectType() != MetadataType.QUERY_ITEM || !(metadataObj instanceof IProperty)) {
            return;
        }
        V5BoundToMetadata v5BoundId = (V5BoundToMetadata)firstObj;
        String roleType = ReplaceDMRBoundIdentifierWithExpression.resolveRoleType(v5BoundId);
        String exprString = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(env, v5BoundId, roleType);
        if (exprString != null) {
            IXQEQueryNode tree = RQPUtilities.createV5ValueExpressionMetadata(exprString, env, null, DMRUtilities.getWrapped(metadataObj));
            firstObj.exchange(tree);
        }
    }

    public static void resetDataType(V5DataItemToMeasureWrapper measure, IXQEQueryNode deco) {
        List items = (List)deco.getPropertyValue(WRAP_MULTI_RSAPIITEMS);
        if (items != null) {
            for (RSAPIDataItem item : items) {
                item.setUsage(RSAPIUsage.FACT);
                item.setModelReference(measure);
                item.setDataType(measure.getDataType());
            }
        }
    }

    public static Set<String> getSubQueryNamesFromV5Query(V5Query query, PlanningEnvironment environment) {
        V5Source source = query.getV5Source();
        IXQEQueryNode[] children = source.getChildren();
        if (children.length == 1 && children[0].getType() == 1007) {
            return Collections.emptySet();
        }
        return query.getSubQueryNames(environment);
    }

    public static void getAllSubQueryNamesFromV5Query(V5Query query, PlanningEnvironment environment, V5QuerySet queryset, Set<String> allSubqueryNames) {
        Set<String> subs = MixedDMRRelUtil.getSubQueryNamesFromV5Query(query, environment);
        for (String s : subs) {
            V5Query sq;
            if (allSubqueryNames.contains(s) || (sq = queryset.getV5Query(s)) == null) continue;
            allSubqueryNames.add(s);
            MixedDMRRelUtil.getAllSubQueryNamesFromV5Query(sq, environment, queryset, allSubqueryNames);
        }
    }

    public static Set<String> dataItemNamesInGroupSort(V5QueryResultDefinition v5QRD) {
        IXQEQueryNode[] sorts;
        HashSet<String> sortItemNames = new HashSet<String>();
        for (IXQEQueryNode aSort : sorts = v5QRD.getDescendantsOfType(101056, false)) {
            String refName = ((V5SortItem)aSort).getRefDataItem();
            sortItemNames.add(refName);
        }
        return sortItemNames;
    }

    public static void convertOLAPUnsupportedExpr(IXQENodeFactory f, IXQEQueryNode node) {
        IXQEQueryNode[] exprs;
        for (IXQEQueryNode e : exprs = node.getDescendantsOfType(201008, true)) {
            ConvertV5BetweenToANDCondition.convertV5BetweenToANDCondition(f, e);
        }
    }

    public final class MixedDMRRelParam {
        protected PlanningEnvironment env;
        protected IXQENodeFactory factory;
        protected V5Selection selection;
        protected HashMap<Integer, Integer> dimToLevel;
        protected ArrayList<RelationalOlapDecorationNode> wrappedMeasures;
        protected ArrayList<RelationalOlapDecorationNode> wrappedLevels;
        protected ArrayList<RelationalOlapDecorationNode> wrappedLevelProps;
    }
}

