/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class PushSummaryFilterToListQuery
extends Transformation {
    public PushSummaryFilterToListQuery() {
        this.mName = "Push summary filter from crosstab query to list query.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] items;
        IXQEQueryNode[] scopeToDelete;
        V5SummaryFilter filter = (V5SummaryFilter)node;
        if (filter.isOLAPConstruct()) {
            filter.setPropertyValue("wrapTo", "none");
            return;
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, v5Query);
        ArrayList<String> dataItemScope = new ArrayList<String>();
        ArrayList<V5DataItemToLevelWrapper> scopeLevels = this.checkAndGetSummaryFilterScopes(env, filter, dataItemScope);
        V5SummaryFilter subSumFilter = (V5SummaryFilter)env.mFactory.deepCopyNode(filter);
        for (IXQEQueryNode del : scopeToDelete = subSumFilter.getChildrenOfTypeOrdered(101012)) {
            subSumFilter.detachChild(del);
        }
        for (IXQEQueryNode item : items = subSumFilter.getDescendantsOfType(101003, false)) {
            V5DataItem v5Item = (V5DataItem)item;
            V5DataItem itemInSelection = env.mSelection.getDataItemByRefName(v5Item.getNameProperty());
            if (!v5Item.getAggregateProperty().equals(itemInSelection.getAggregateProperty())) {
                v5Item.setAggregateProperty(itemInSelection.getAggregateProperty());
            }
            if (v5Item.getRollupAggregateProperty().equals(itemInSelection.getRollupAggregateProperty())) continue;
            v5Item.setRollupAggregateProperty(itemInSelection.getRollupAggregateProperty());
        }
        env.mTabQuery.addChild(subSumFilter);
        TabStreamUtil.transformExprNodeSummariesRemoveRefDataItems(env, env.mTabSelection, subSumFilter.getChild(0), dataItemScope, scopeLevels);
        filter.detach();
    }

    protected ArrayList<V5DataItemToLevelWrapper> checkAndGetSummaryFilterScopes(TabStreamUtil.WrapCommonObjects env, V5SummaryFilter filter, ArrayList<String> dataItemScope) {
        ArrayList<V5DataItemToLevelWrapper> rt = new ArrayList<V5DataItemToLevelWrapper>();
        IXQEQueryNode[] scope = filter.getChildrenOfTypeOrdered(101012);
        if (scope.length == 0) {
            return rt;
        }
        HashSet<String> itemsInScope = new HashSet<String>();
        for (IXQEQueryNode s : scope) {
            V5SummaryFilterLevel filterLevel = (V5SummaryFilterLevel)s;
            String item = filterLevel.getRefDataItem();
            itemsInScope.add(item);
        }
        HashSet<String> itemsRenamed = new HashSet<String>();
        int i = 0;
        for (i = 0; i < env.mSelection.getNumberChildren(); ++i) {
            String orgName = (String)((V5DataItem)env.mSelection.getChild(i)).getPropertyValue("orgName");
            if (orgName == null || !itemsInScope.contains(orgName)) continue;
            itemsRenamed.add(orgName);
        }
        itemsInScope.addAll(itemsRenamed);
        List<IXQEQueryNode> edges = env.mQRD.getDescendantsOfTypeOrdered(101049, false);
        ArrayList<String> refItemInEdges = new ArrayList<String>();
        ArrayList<IXQEQueryNode> refValueSetInEdges = new ArrayList<IXQEQueryNode>();
        for (i = 0; i < edges.size(); ++i) {
            refItemInEdges.add(null);
            refValueSetInEdges.add(null);
            List<IXQEQueryNode> nodes = edges.get(i).getDescendantsOfTypeOrdered(101057, false);
            for (IXQEQueryNode node : nodes) {
                V5ValueSet vs = (V5ValueSet)node;
                String refItem = vs.getRefDataItemProperty();
                if (refItem == null || !itemsInScope.contains(refItem)) continue;
                itemsInScope.remove(refItem);
                String seen = (String)refItemInEdges.get(i);
                if (seen == null) {
                    refItemInEdges.set(i, refItem);
                    refValueSetInEdges.set(i, node);
                    continue;
                }
                if (refItem.equals(seen)) continue;
                StringBuilder sb = new StringBuilder();
                XQEMessage.appendQuotedItem(sb, seen);
                XQEMessage.appendQuotedItem(sb, refItem);
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsuppMultSummFilterScopesOnSingleEdge, sb.toString(), (IXQEQueryNode)filter);
                throw new XQEOlapUnsupportedQueryException(message);
            }
        }
        if (itemsInScope.size() > 0) {
            StringBuilder sb = new StringBuilder();
            XQEMessage.appendQuotedItemList(sb, itemsInScope);
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsuppSummFilterScopesNotProj, sb.toString(), (IXQEQueryNode)filter);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        for (IXQEQueryNode aValueSet : refValueSetInEdges) {
            if (aValueSet == null) continue;
            rt.add(TabStreamUtil.getLevel(env, (V5ValueSet)aValueSet));
            List<String> forClause = TabStreamUtil.getForClauseItems(env, (V5ValueSet)aValueSet);
            dataItemScope.addAll(forClause);
        }
        return rt;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Object flag = node.getPropertyValue("wrapTo");
        if (flag == null) {
            V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
            V5Source src = v5Query.getV5Source();
            Object cube = src.getPropertyValue("needTabularStream");
            status = cube instanceof CubeWrapper;
        }
        if (status) {
            this.traceNodeCondition(status, "need to push the summary filter to list query.", trace);
        } else {
            this.traceNodeCondition(status, "can't push the summary filter to list query.", trace);
        }
        return status;
    }
}

