/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.transformation.v5.unwinding.UnwindV5BoundModelId;

public final class RefineCalculatedForRelationalXtab
extends Transformation {
    public static final String REFINE_AGGR_ROLLUP = "refineAggrRollUpTypes";

    public RefineCalculatedForRelationalXtab() {
        this.mName = "Refine the calculated aggregate and/or rollUp aggregate types in Xtab.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem = (V5DataItem)node;
        v5DataItem.setPropertyValue(REFINE_AGGR_ROLLUP, Boolean.TRUE);
        String aggr = v5DataItem.getAggregateProperty();
        String rollUp = v5DataItem.getRollupAggregateProperty();
        RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggr);
        if ("calculated".equals(aggr) && node.getChild(0).getType() == 201116) {
            UnwindV5BoundModelId t = new UnwindV5BoundModelId(new int[]{1});
            t.apply(node.getChild(0), environment);
        }
        if ("calculated".equals(aggr) && (aggrType = RefineAutomaticXtab.determineAggrType(environment, node.getChild(0), aggrType)) != RefineAutomaticXtab.AggrTypeEnum.CALCULATED) {
            v5DataItem.setAggregateProperty(aggrType.getV5Name());
        }
        if ("calculated".equals(rollUp)) {
            RefineAutomaticXtab.AggrTypeEnum rollUpType = RefineAutomaticXtab.AggrTypeEnum.CALCULATED;
            IXQEQueryNode v5Query = v5DataItem.getAncestorOfType(101006);
            if (v5Query.getPropertyValue("queryUsesBridge") != Boolean.TRUE) {
                rollUpType = TabStreamUtil.determineCalculatedRollupAggrType(aggrType);
            }
            if (rollUpType != RefineAutomaticXtab.AggrTypeEnum.CALCULATED) {
                if (v5DataItem.getPropertyValue("orgRollupAggregate") == null) {
                    v5DataItem.setPropertyValue("orgRollupAggregate", rollUp);
                }
                v5DataItem.setRollupAggregateProperty(rollUpType.getV5Name());
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = this.needRefineCalculatedAggregateRollUp((V5DataItem)node);
        if (status) {
            this.traceNodeCondition(status, "need to refine calculated aggregate and/or rollUp aggregate type in Relational XTab.", trace);
        } else {
            this.traceNodeCondition(status, "no calculated aggregate or rollUp aggregate type.", trace);
        }
        return status;
    }

    protected boolean needRefineCalculatedAggregateRollUp(V5DataItem v5DataItem) {
        if (v5DataItem.getPropertyValue(REFINE_AGGR_ROLLUP) != null) {
            return false;
        }
        String aggr = v5DataItem.getAggregateProperty();
        String rollUp = v5DataItem.getRollupAggregateProperty();
        if (!"calculated".equals(aggr) && !"calculated".equals(rollUp)) {
            return false;
        }
        V5Query v5Query = (V5Query)v5DataItem.getAncestorOfType(101006);
        if (v5Query == null) {
            return false;
        }
        V5Source src = v5Query.getV5Source();
        Object cube = src.getPropertyValue("needTabularStream");
        return cube instanceof CubeWrapper;
    }
}

