/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.TreeSet;

public final class SetTNodeInformationOnNonDetailGroupBodySort
extends Transformation {
    public SetTNodeInformationOnNonDetailGroupBodySort() {
        this.mName = "Set TNode Information on non detail gorup body sort.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = ((V5QueryResultDefinition)node).getV5Query();
        MixedDMRRelUtil.MixedDMRRelParam param = MixedDMRRelUtil.createParam();
        param.env = environment;
        param.factory = environment.getNodeFactory();
        param.selection = query.getV5Selection();
        MixedDMRRelUtil.collectWrappedMeasuresAndLevels(param);
        ArrayList<V5ValueSet> vs = this.getV5ValueSetsWithUnResolvedTNodeInGroupBodySort(node);
        for (V5ValueSet v : vs) {
            TreeSet<String> itemsInBodySort = new TreeSet<String>();
            TabStreamUtil.collectItemsInGroupBodySort(v, itemsInBodySort);
            int pos = 0;
            for (String prop : itemsInBodySort) {
                IXQEQueryNode[] tnodes;
                V5DataItem v5DataItem = param.selection.getDataItemByRefName(prop);
                for (IXQEQueryNode tnode : tnodes = v5DataItem.getDescendantsOfType(601024, false)) {
                    RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                    Integer tp = relOLAPDeco.getWrapType();
                    if (tp != null) continue;
                    String[] aggrRollUp = new String[]{null, null, null};
                    tp = MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp);
                    if (tp == 0) {
                        MixedDMRRelUtil.wrapToMeasure(relOLAPDeco, param, aggrRollUp);
                        continue;
                    }
                    boolean toProperty = false;
                    String topTp = v.getMixedDMRRelational();
                    if (topTp.startsWith("TBlevel_")) {
                        toProperty = this.checkTNodeForProperty(relOLAPDeco);
                    }
                    if (toProperty) {
                        int idx = topTp.indexOf("_");
                        MixedDMRRelUtil.wrapToLevelProperty(relOLAPDeco, param, topTp.substring(idx + 1), Integer.toString(pos), prop);
                        ++pos;
                        if (!TabStreamUtil.itemUsedByGroupBody(v, prop)) continue;
                        this.setRSAPI(relOLAPDeco, param, (V5QueryResultDefinition)node, v, prop);
                        continue;
                    }
                    MixedDMRRelUtil.wrapToNewOrExistLevel(relOLAPDeco, param, aggrRollUp[2]);
                }
            }
        }
    }

    protected void setRSAPI(IXQEQueryNode tnode, MixedDMRRelUtil.MixedDMRRelParam param, V5QueryResultDefinition qrd, V5ValueSet valueSet, String itemName) {
        String rowsetName;
        V5Edge edge;
        String edgeName;
        IXQEQueryNode rsapiNode = qrd.getAncestorOfType(401005);
        RSAPIDataItem item = TabStreamUtil.getRSAPIDataItemByName(rsapiNode, edgeName = (String)(edge = (V5Edge)valueSet.getAncestorOfType(101049)).getPropertyValue("name"), rowsetName = valueSet.getNameProperty(), itemName);
        if (item != null) {
            tnode.setPropertyValue("rsapiItem", item);
        }
    }

    protected boolean checkTNodeForProperty(IXQEQueryNode tnode) {
        IXQEQueryNode parent = tnode.getParent();
        if (parent.getType() != 101003) {
            return false;
        }
        return (parent = parent.getParent()).getType() == 101009;
    }

    protected ArrayList<V5ValueSet> getV5ValueSetsWithUnResolvedTNodeInGroupBodySort(IXQEQueryNode node) {
        IXQEQueryNode[] valueSets;
        ArrayList<V5ValueSet> r = new ArrayList<V5ValueSet>();
        V5Query query = ((V5QueryResultDefinition)node).getV5Query();
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode vs : valueSets = node.getDescendantsOfType(101057, false)) {
            String refDataItem = ((V5ValueSet)vs).getRefDataItemProperty();
            if (refDataItem == null) continue;
            TreeSet<String> itemsInBodySort = new TreeSet<String>();
            TabStreamUtil.collectItemsInGroupBodySort((V5ValueSet)vs, itemsInBodySort);
            boolean hasUnResolvedTNodes = false;
            for (String prop : itemsInBodySort) {
                IXQEQueryNode[] tnodes;
                V5DataItem v5DataItem = selection.getDataItemByRefName(prop);
                for (IXQEQueryNode tnode : tnodes = v5DataItem.getDescendantsOfType(601024, false)) {
                    RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                    Integer tp = relOLAPDeco.getWrapType();
                    if (tp != null) continue;
                    hasUnResolvedTNodes = true;
                    break;
                }
                if (!hasUnResolvedTNodes) continue;
                break;
            }
            if (!hasUnResolvedTNodes) continue;
            r.add((V5ValueSet)vs);
        }
        return r;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        Boolean b = ((V5QueryResultDefinition)node).isMixedDMRRelational();
        boolean bl = status = b != null && b != false;
        if (status) {
            ArrayList<V5ValueSet> vs = this.getV5ValueSetsWithUnResolvedTNodeInGroupBodySort(node);
            boolean bl2 = status = !vs.isEmpty();
        }
        if (status) {
            this.traceNodeCondition(status, "need to set TNode information on the group body sort.", trace);
        } else {
            this.traceNodeCondition(status, "don't set TNode information on the group body sort.", trace);
        }
        return status;
    }
}

